/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * FontFileRecord.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.registry;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/**
 * Todo: Document me!
 *
 * @author : Thomas Morgner
 */
public class FontFileRecord implements Serializable
{
  private long lastAccessTime;
  private long fileSize;
  private String filename;

  public FontFileRecord(final File file) throws IOException
  {
    this(file.getCanonicalPath(), file.length(), file.lastModified());
  }

  public FontFileRecord(final String filename,
                           final long fileSize,
                           final long lastAccessTime)
  {
    if (filename == null)
    {
      throw new NullPointerException();
    }
    this.filename = filename;
    this.fileSize = fileSize;
    this.lastAccessTime = lastAccessTime;
  }

  public long getLastAccessTime()
  {
    return lastAccessTime;
  }

  public long getFileSize()
  {
    return fileSize;
  }

  public String getFilename()
  {
    return filename;
  }

  public boolean equals(final Object o)
  {
    if (this == o)
    {
      return true;
    }
    if (o == null || getClass() != o.getClass())
    {
      return false;
    }

    final FontFileRecord that = (FontFileRecord) o;

    if (fileSize != that.fileSize)
    {
      return false;
    }
    if (lastAccessTime != that.lastAccessTime)
    {
      return false;
    }
    if (!filename.equals(that.filename))
    {
      return false;
    }

    return true;
  }

  public int hashCode()
  {
    int result = (int) (lastAccessTime ^ (lastAccessTime >>> 32));
    result = 29 * result + (int) (fileSize ^ (fileSize >>> 32));
    result = 29 * result + filename.hashCode();
    return result;
  }
}
