/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(IXMLElement iXMLElement) throws IOException {
        this.write(iXMLElement, false, 0, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl) throws IOException {
        this.write(iXMLElement, bl, 0, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl, int n) throws IOException {
        this.write(iXMLElement, bl, n, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl, int n, boolean bl2) throws IOException {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.writer.print(' ');
            }
        }
        if (iXMLElement.getName() == null) {
            if (iXMLElement.getContent() != null) {
                if (bl) {
                    this.writeEncoded(iXMLElement.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(iXMLElement.getContent());
                }
            }
        } else {
            Object object;
            Iterator<IXMLElement> iterator;
            this.writer.print('<');
            this.writer.print(iXMLElement.getFullName());
            Vector<Object> vector = new Vector<Object>();
            if (iXMLElement.getNamespace() != null) {
                if (iXMLElement.getName().equals(iXMLElement.getFullName())) {
                    this.writer.print(" xmlns=\"" + iXMLElement.getNamespace() + '\"');
                } else {
                    iterator = iXMLElement.getFullName();
                    iterator = ((String)((Object)iterator)).substring(0, ((String)((Object)iterator)).indexOf(58));
                    vector.addElement(iterator);
                    this.writer.print(" xmlns:" + iterator);
                    this.writer.print("=\"" + iXMLElement.getNamespace() + "\"");
                }
            }
            iterator = iXMLElement.iterateAttributeNames();
            while (iterator.hasNext()) {
                String string;
                String string2;
                object = iterator.next();
                int n2 = ((String)object).indexOf(58);
                if (n2 < 0 || (string2 = iXMLElement.getAttributeNamespace((String)object)) == null || vector.contains(string = ((String)object).substring(0, n2))) continue;
                this.writer.print(" xmlns:" + string);
                this.writer.print("=\"" + string2 + '\"');
                vector.addElement(string);
            }
            iterator = iXMLElement.iterateAttributeNames();
            while (iterator.hasNext()) {
                object = iterator.next();
                String string = iXMLElement.getAttribute((String)object, null);
                this.writer.print(" " + (String)object + "=\"");
                this.writeEncoded(string);
                this.writer.print('\"');
            }
            if (iXMLElement.getContent() != null && iXMLElement.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(iXMLElement.getContent());
                this.writer.print("</" + iXMLElement.getFullName() + '>');
                if (bl) {
                    this.writer.println();
                }
            } else if (iXMLElement.hasChildren() || !bl2) {
                this.writer.print('>');
                if (bl) {
                    this.writer.println();
                }
                iterator = iXMLElement.iterateChildren();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.write((IXMLElement)object, bl, n + 4, bl2);
                }
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + iXMLElement.getFullName() + ">");
                if (bl) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (bl) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String string) {
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    continue block8;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

