#lang scribble/doc
@(require "utils.rkt")

@title[#:tag "intro"]{Overview}

Although using the FFI requires writing no new C code, it provides
very little insulation against the issues that C programmers face
related to safety and memory management. An FFI programmer must be
particularly aware of memory management issues for data that spans the
Racket--C divide. Thus, this manual relies in many ways on the
information in @|InsideRacket|, which defines how Racket
interacts with C APIs in general.

Since using the FFI entails many safety concerns that Racket
programmers can normally ignore, the library name includes
@racketidfont{unsafe}. Importing the library macro should be
considered as a declaration that your code is itself unsafe, therefore
can lead to serious problems in case of bugs: it is your
responsibility to provide a safe interface. If your library provides
an unsafe interface, then it should have @racketidfont{unsafe} in its
name, too.

For examples of common FFI usage patterns, see the defined interfaces
in the @filepath{ffi} collection.
