/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.extra;

import com.opensymphony.module.oscache.base.events.ScopeEvent;
import com.opensymphony.module.oscache.base.events.ScopeEventListener;
import com.opensymphony.module.oscache.base.events.ScopeEventType;

public class ScopeEventListenerImpl
implements ScopeEventListener {
    private static final int NB_SCOPES = 4;
    private static final int PAGE_SCOPE = 1;
    private static final int REQUEST_SCOPE = 2;
    private static final int SESSION_SCOPE = 3;
    private static final int APPLICATION_SCOPE = 4;
    private int[] scopeFlushCount = new int[5];

    public void scopeFlushed(ScopeEvent scopeEvent) {
        ScopeEventType scopeEventType = scopeEvent.getEventType();
        if (scopeEventType == ScopeEventType.ALL_SCOPE_FLUSHED) {
            int n = 1;
            while (n <= 4) {
                int n2 = n++;
                this.scopeFlushCount[n2] = this.scopeFlushCount[n2] + 1;
            }
        } else if (scopeEventType == ScopeEventType.SCOPE_FLUSHED) {
            int n = scopeEvent.getScope();
            this.scopeFlushCount[n] = this.scopeFlushCount[n] + 1;
        } else {
            throw new IllegalArgumentException("Unknown Scope Event type received");
        }
    }

    public int getPageScopeFlushCount() {
        return this.scopeFlushCount[1];
    }

    public int getRequestScopeFlushCount() {
        return this.scopeFlushCount[2];
    }

    public int getSessionScopeFlushCount() {
        return this.scopeFlushCount[3];
    }

    public int getApplicationScopeFlushCount() {
        return this.scopeFlushCount[4];
    }

    public int getTotalScopeFlushCount() {
        int n = 0;
        int n2 = 1;
        while (n2 <= 4) {
            n += this.scopeFlushCount[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Flush count for ");
        int n = 1;
        while (n <= 4) {
            stringBuffer.append("scope " + n + " = " + this.scopeFlushCount[n] + ", ");
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }
}

