/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.general;

import com.opensymphony.module.oscache.base.AbstractCacheAdministrator;
import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.EntryRefreshPolicy;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.base.persistence.DiskPersistenceListener;
import java.util.Date;

public final class GeneralCacheAdministrator
extends AbstractCacheAdministrator {
    private static GeneralCacheAdministrator admin = null;
    private Cache applicationCache = null;

    public static GeneralCacheAdministrator getInstance() {
        if (admin == null) {
            admin = new GeneralCacheAdministrator();
        }
        return admin;
    }

    public Cache getCache() {
        if (this.applicationCache == null) {
            this.applicationCache = this.createCache();
        }
        return this.applicationCache;
    }

    private Cache createCache() {
        this.log("Created new cache");
        Cache cache = new Cache(this.isMemoryCaching(), this.isUnlimitedDiskCache(), this.algorithmClass, this.cacheCapacity);
        if (this.isFileCaching()) {
            StringBuffer stringBuffer = new StringBuffer(this.getCachePath().getPath());
            cache.setPersistenceListener(new DiskPersistenceListener(stringBuffer.toString()));
        }
        return cache;
    }

    public void flushAll(Date date) {
        this.getCache().flushAll(date);
    }

    public void putInCache(String string, Object object, EntryRefreshPolicy entryRefreshPolicy) {
        Cache cache = this.getCache();
        cache.putInCache(string, object, entryRefreshPolicy);
    }

    public void putInCache(String string, Object object) {
        this.putInCache(string, object, null);
    }

    public Object getFromCache(String string, int n) throws NeedsRefreshException {
        return this.getCache().getFromCache(string, n);
    }

    public void flushPattern(String string) {
        this.getCache().flushPattern(string);
    }

    private GeneralCacheAdministrator() {
        this.log("Constructed GeneralCacheAdministrator()");
    }
}

