\name{setBrushColor.ggobi}
\alias{setBrushColor.ggobi}
\alias{getBrushColor.ggobi}
\alias{getBrushGlyph.ggobi}
\alias{setBrushGlyph.ggobi}
\title{Set or retrieve the settings for the appearance of a ggobi brush}
\description{
 The appearance of the ``brush'' -- the  control for the selection
 of points or a region -- can be manipulated per ggobi
 instance. These functions control the color of 
 the brush region and the points within it,
  and also the glyph used to display the selected points within
 this region.
}
\usage{
setBrushColor.ggobi(id, .gobi=getDefaultGGobi())
getBrushColor.ggobi(.gobi=getDefaultGGobi())
setBrushGlyph.ggobi(type, size, .gobi=getDefaultGGobi())
getBrushGlyph.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{id}{the identifier for the color to which the corresponding
   value of the brush region is to be set. For a color, this can be either a name
   (as in the row names from \code{getColorMap.ggobi} or an integer identifying
   the particular row/entry of the color map.}
  \item{type}{the identifier of the glyph}
  \item{size}{an integer specifying the size to which the brush  glyph should be set.}
  \item{.gobi}{the ggobi identifier, either an object of class \code{ggobi}
   or an integer.}
}
\value{
 The \code{get} methods   return the current value for the attribute
 in effect at present.
 In the \code{set} methods, the value in effect before the  call
 is returned. This can be used to restore the original settings
 after some event.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{setBrushSize.ggobi}}
\code{\link{getBrushSize.ggobi}}
\code{\link{setBrushLocation.ggobi}}
\code{\link{getBrushLocation.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")

##  g$setBrushColor("red")

  g$setMode("Brush")

  g$setBrushGlyph("plus")
}
\concept{visualization}
\concept{interactive graphics}
\keyword{iplot}
\keyword{dynamic}
