\name{ggobi}
\alias{ggobi}
\title{Creates a new ggobi instance}
\description{
Create a new instance of a GGobi control panel
with or without new data.
This new GGobi will operate indepdently of the others
in the R session and will not share linked plots.
}
\usage{
  ggobi(data = NULL, args=character(0), mode=character(0), name = deparse(sys.call()[[2]]), ...)
}
\arguments{
 \item{data}{the name of a file containing the data to be loaded
or a data frame or matrix containing the values}
 \item{args}{a character vector of arguments that are given to the
ggobi engine as if they were specified as command line arguments
to the stand-alone ggobi. This includes flags such as \texttt{-xml},
\texttt{-a}, etc. to specify the mode of the data being read from a file.}
\item{mode}{the name of the data format GGobi should expect to read
  the data from, if reading from a file.}
\item{name}{the name to use in GGobi for the dataset, if one is specified}
\item{...}{passed to \code{\link{setData.ggobi}}}
}
\details{
 This creates a new ggobi object which manages one or more
related datasets and a linked collection of views of the values in
those datasets.
}
\value{
 An object that can be used in subsequent calls
to identify this particular ggobi instance.
This is a list with two elements:
 \item{id}{an integer identifying which ggobi instance
  this was within the R session.}
 \item{ref}{the C-level address of the internal \code{ggobid} structure. Do no use!}
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{getDefaultGGobi}},
\code{\link{getNumGGobis}}
}

\examples{
 ggobi(system.file("data", "flea.dat", package="Rggobi"), c("-noinit", "-ascii"))
 ggobi(system.file("data", "flea.xml", package="Rggobi"), c("-noinit", "-xml"))

 ggobi(system.file("data", "flea.xml", package="Rggobi"), args= "-noinit")

 data(mtcars)
 ggobi(mtcars)
}
\keyword{dynamic}

