/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

/**
 * Represents a database that is always disconnected.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */

public final class DisconnectedDatabaseModel extends DatabaseModel {
	/**
	 * Creates a new <code>DisconnectedDatabaseModel</code> instance.
	 */
	public DisconnectedDatabaseModel()
	{
		setName("[" +
		        ExplainResources.getString(ExplainResources.CONNECTION_CLOSED) +
		        "]");
	}

	// inherits doc comment
	public String getURL()
	{
		return getName();
	}

	// inherits doc comment
	public Object clone()
	{
		DisconnectedDatabaseModel d = new DisconnectedDatabaseModel();

		d.setName(getName());
		d.setDatabase(getDatabase());
		d.setHost(getHost());
		d.setPort(getPort());
		d.setUser(getUser());
		d.setPassword(getPassword());
		d.setDriver(getDriver());

		return d;
	}
}// DisconnectedDatabaseModel
