/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __ICONLIST_H__
#define __ICONLIST_H__

#include "picture.h"
#include "plugin.h"
#include "object.h"

/*
This is mainly designed to be a fast lookup table.

Needs massive cleanup!
*/

struct iconlist
{
	/* General Components */
	char *name[256];
	int numicons[256];
	struct classheader *classindex[256];

	/* Colors for point icons: 0 -> 63 */
	unsigned char *rgb_r[64];
	unsigned char *rgb_g[64];
	unsigned char *rgb_b[64];
	
	/* Pixmaps for picture icons: 64 -> 195 */
	struct picture *icon[128];

	/* Data for line types: 196 -> 223 */
	unsigned char *line_r[32];
	unsigned char *line_g[32];
	unsigned char *line_b[32];
	float *line_thick[32];

	/* Plugin type: 224 -> 254 */
	plugindrawfunc *drawfuncs[32];
	pluginprintfunc *printfuncs[32];
	unsigned char *func_r[32];
	unsigned char *func_g[32];
	unsigned char *func_b[32];
};

struct iconlist *newiconlist(const char *iconlistfile);
void destroyiconlist(struct iconlist *);

#endif
