(in-package "ACL2")

(include-book "merge")
(include-book "stick")


;sumbits

(defun sumbits (x n)
  (if (zp n)
      0
    (+ (* (expt 2 (1- n)) (bitn x (1- n)))
       (sumbits x (1- n)))))

(defthm sumbits-bits
    (implies (and (natp x)
		  (natp n)
		  (> n 0))
	     (equal (sumbits x n)
		    (bits x (1- n) 0)))
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite)
		  :induct (sumbits x n))
	  ("Subgoal *1/2" :use ((:instance bits-plus-bitn (n (1- n)) (m 0))))))

(in-theory (disable sumbits-bits))

(defthm sumbits-thm
    (implies (and (bvecp x n)
		  (natp n)
		  (> n 0))
	     (equal (sumbits x n)
		    x))
  :hints (("Goal" :in-theory (enable sumbits-bits))))

(in-theory (disable sumbits-thm))

;removed bitn-bvecp-0, et seq.







(defthm logior-0-x
    (implies (natp x)
	     (equal (logior 0 x) x))
  :hints (("Goal" :in-theory (disable logior-commutative)
		  :use ((:instance logior-commutative (y 0))))))

(local (defun ls-induct (k x)
  (if (zp k)
      x
    (ls-induct (1- k) (fl (/ x 2))))))

(local-defthm logior-ones-3-1
    (implies (and (integerp k) (> k 0))
	     (= (fl (/ (1- (expt 2 k)) 2))
		(1- (expt 2 (1- k)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance fl-unique (x (/ (1- (expt 2 k)) 2)) (n (1- (expt 2 (1- k)))))))))

(local-defthm logior-ones-3-2
    (implies (and (integerp k) (> k 0))
	     (= (rem (1- (expt 2 k)) 2) 1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem-mod-2 (x (1- (expt 2 k))))
			(:instance rem-mod-2-not-equal (x (1- (expt 2 k))))
			(:instance rem-2*i-rewrite (i (expt 2 (1- k))))))))

(local-defthm logior-ones-3
    (implies (and (integerp k) (>= k 0)
		  (integerp x) (>= x 0) (< x (expt 2 k)))
	     (= (logior (1- (expt 2 k)) x)
		(1- (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :induct (ls-induct k x))
	  ("Subgoal *1/2" :use (logior-ones-3-1
				logior-ones-3-2
				rem-mod-2
				(:instance quot-rem (m x) (n 2))
				(:instance quot-rem (m (logior (1- (expt 2 k)) x)) (n 2))
				(:instance natp-logior (i (1- (expt 2 k))) (j x))
				(:instance fl-def-linear (x (/ x 2)))
				(:instance logior-fl-2 (i (1- (expt 2 k))) (j x))
				(:instance logior-rem-2 (i (1- (expt 2 k))) (j x))))))

(defthm logior-ones
    (implies (and (natp n)
		  (bvecp x n))
	     (equal (logior x (1- (expt 2 n)))
		    (1- (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance logior-ones-3 (k n))))))

(defthm logxor-ones
    (implies (and (natp n)
		  (bvecp x n))
	     (equal (logxor x (1- (expt 2 n)))
		    (comp1 x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable comp1 bvecp)
		  :use (bvecp-comp1
			(:instance logxor-rewrite-2 (y (1- (expt 2 n))))
			(:instance logand-ones (x (comp1 x n)))))))

(defthm comp1-2+1
    (implies (and (natp x)
		  (natp n))
	     (equal (+ 1 (* 2 (comp1 x n)))
		    (comp1 (* 2 x) (1+ n))))
    :hints (("Goal" :in-theory (enable comp1 bvecp))))

(in-theory (enable bvecp-bits))

(in-theory (disable bitn-bvecp-0))

(in-theory (disable rem-equal))

(in-theory (enable bits-n-n-rewrite))

(defthm bits-logxor
    (implies (and (bvecp x n)
		  (bvecp y n)
		  (natp n)
		  (natp i)
		  (natp j)
		  (> n i)
		  (>= i j))
	     (equal (bits (logxor x y) i j)
		    (logxor (bits x i j) (bits y i j)))))

(local-defthm hack1
    (implies (natp x)
	     (> (expt 2 x) x))
  :rule-classes ())

(defthm bits-logxor-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j))
	     (equal (bits (logxor x y) i j)
		    (logxor (bits x i j) (bits y i j))))
  :hints (("Goal" :in-theory (enable bvecp natp)
		  :use ((:instance hack1 (x (+ i x y)))
			(:instance bits-logxor (n (+ i x y)))))))

(in-theory (disable bits-logxor-2))

;bvecp-bits-0 moved to merge.lisp


(defthm bits-shift-4
    (implies (and (natp x)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (>= i (+ j l))
		  (< i (+ j k)))
	     (equal (bits (bits x i j) k l)
		    (bits x i (+ l j))))
    :hints (("Goal" :in-theory (enable natp)
		    :use ((:instance bits-shift-3 (k (- i j)))
			  (:instance bvecp-bits-0 (x (bits x i j)) (i k) (j (1+ (- i j))))
			  (:instance bits-plus-bits (x (bits x i j)) (m (1+ k)) (n (1+ (- i j))) (r l))))))

(in-theory (disable bits-shift-4))

(in-theory (enable bvecp-comp1 bvecp-cat))

(in-theory (enable bvecp-logand bvecp-logior))

(in-theory (enable bvecp-logxor))

(include-book "add3")

(defthm add-3
    (implies (and (natp x)
		  (natp y)
		  (natp z))
	     (= (+ x y z)
		(+ (logxor x (logxor y z))
		   (* 2 (logior (logand x y)
				(logior (logand x z)
					(logand y z)))))))
  :rule-classes ()
  :hints (("Goal" :use add3)))

(defthm add-2
    (implies (and (natp x) (natp y))
	     (equal (+ x y)
		    (+ (logxor x y)
		       (* 2 (logand x y)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance add3 (z 0))))))

(defun logop-3-induct (x y z)
  (declare (xargs :measure (+ (nfix x) (nfix y) (nfix z))))
  (if (and (natp x) (natp y) (natp z))
      (if (and (zp x) (zp y) (zp z))
	  t
	(logop-3-induct (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2))))
    t))

(defun log3a (x y z)
  (logior (logand x y) (logior (logand x z) (logand y z))))

(defun log3b (x y z)
  (logior (logand x y) (logand (logxor x y) z)))

(defthm logand-fl-2-rewrite
    (implies (and (natp x)
		  (natp y))
	     (equal (fl (* 1/2 (logand x y)))
		    (logand (fl (* 1/2 x)) (fl (* 1/2 y)))))
  :hints (("Goal" :use (logand-fl-2))))

(defthm logior-fl-2-rewrite
    (implies (and (natp i)
		  (natp j))
	     (equal (fl (* 1/2 (logior i j)))
		    (logior (fl (* 1/2 i)) (fl (* 1/2 j)))))
  :hints (("Goal" :use (logior-fl-2))))

(defthm logxor-fl-2-rewrite
    (implies (and (natp i)
		  (natp j))
	     (equal (fl (* 1/2 (logxor i j)))
		    (logxor (fl (* 1/2 i)) (fl (* 1/2 j)))))
  :hints (("Goal" :use (logxor-fl-2))))

(in-theory (disable logand-fl-2-rewrite logior-fl-2-rewrite logxor-fl-2-rewrite))

(local-defthm log3-1
    (implies (and (natp x) (natp y) (natp z)
		  (equal (log3a (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2)))
			 (log3b (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2)))))
	     (equal (log3a x y z)
		    (log3b x y z)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable logior-rem-2 logand-rem-2 logxor-rem-2
				     logand-fl-2-rewrite logior-fl-2-rewrite logxor-fl-2-rewrite)
		  :use (rem-mod-2
			(:instance rem-mod-2 (x y))
			(:instance rem-mod-2 (x z))
			(:instance quot-rem (m (log3a x y z)) (n 2))
			(:instance quot-rem (m (log3b x y z)) (n 2))))))

(defun logop-induct (x y z)
  (declare (xargs :measure (+ (nfix x) (nfix y) (nfix z))))
  (if (and (natp x) (natp y) (natp z))
      (if (and (zp x) (zp y) (zp z))
	  t
	(logop-induct (fl (/ x 2)) (fl (/ y 2)) (fl (/ z 2))))
    t))

(defthm log3
    (implies (and (natp x) (natp y) (natp z))
	     (equal (logior (logand x y) (logior (logand x z) (logand y z)))
		    (logior (logand x y) (logand (logxor x y) z))))
  :rule-classes ()
  :hints (("Goal" :induct (logop-induct x y z))
	  ("Subgoal *1/2" :use (log3-1))))

(in-theory (disable bitn-rem-bitn))

(local-defthm hack-3
    (implies (and (natp k)
		  (natp n)
		  (> k n)
		  (natp y))
	     (NATP (* Y (EXPT 2 (+ -1 K (* -1 N))))))
  :hints (("Goal" :in-theory (union-theories (disable a14) '(natp))
		  :use ((:instance natp-posp-expt (n (- k (1+ n))))))))

(defthm bits-plus-mult-2
    (implies (and (natp m)
		  (natp n)
		  (>= n m)
		  (natp k)
		  (> k n)
		  (natp y)
		  (natp x))
	     (= (bits (+ x (* y (expt 2 k))) n m)
		(bits x n m)))
    :rule-classes ()
    :hints (("Goal" :in-theory (disable a14)
		    :use ((:instance rem-bits-equal
				     (y (+ x (* y (expt 2 k))))
				     (i n)
				     (j m))
			  (:instance rem-mult
				     (m x)
				     (n (expt 2 (1+ n)))
				     (a (* (expt 2 (- k (1+ n))) y)))
			  (:instance natp-posp-expt (n (- k (1+ n))))))))


;move to stick, but move bvecp up first

(in-theory (disable tau))

(defthm bvecp-sigm
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (sigm a b c n) n))
  :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (sigm-bnds))))

(defthm bvecp-kap
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (kap a b n) (1+ n)))
    :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (kap-bnds))))

(defthm bvecp-tau
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (tau a b c n) (1+ n)))
    :rule-classes ()
    :hints (("Goal" :in-theory (enable bvecp)
		    :use (tau-bnds))))

(defthm top-thm-2
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n)
		  (natp k)
		  (< k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (bits (+ a b c) k 0) 0)
		  (= (bits (tau a b c n) k 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp)
		  :use (stick-lemma
			bvecp-tau
			(:instance bits-rem (x (+ a b c)) (n k))
			(:instance bits-rem (x (tau a b c n)) (n k))))))


(defthm rem-rem-sum
    (implies (and (natp a)
		  (natp b)
		  (natp n))
	     (equal (rem (+ (rem a n) (rem b n)) n)
		    (rem (+ a b) n)))
  :hints (("Goal" :use (rem-sum
			(:instance rem-sum (a (rem b n)) (b a))))))


(local-defthm sticky-21-1
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (= (bits (+ (bits x (1- k) 0)
			 (bits y (1- k) 0))
		      (1- k) 0)
		0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use ((:instance rem-rem-sum (a x) (b y) (n (expt 2 k)))))))

(local-defthm sticky-21-2
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 
		      (+ (bits x (1- k) 0)
			 (bits y (1- k) 0)))
		  (< (+ (bits x (1- k) 0)
			(bits y (1- k) 0))
		     (expt 2 (1+ k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use ((:instance rem-bnd-1 (m x) (n (expt 2 k)))
			(:instance rem-bnd-1 (m y) (n (expt 2 k)))))))

(local-defthm sticky-21-3
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 
		      (/ (+ (bits x (1- k) 0)
			    (bits y (1- k) 0))
			 (expt 2 k)))
		  (< (/ (+ (bits x (1- k) 0)
			   (bits y (1- k) 0))
			(expt 2 k))
		     2)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable a2 expt-inverse)
		  :use (sticky-21-2))))


(local-defthm sticky-21-4
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (and (<= 0 (fl (/ (+ (bits x (1- k) 0)
				  (bits y (1- k) 0))
			       (expt 2 k))))
		  (< (fl (/ (+ (bits x (1- k) 0)
				  (bits y (1- k) 0))
			    (expt 2 k)))
		     2)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-3
			(:instance n<=fl-linear
				   (n 0) 
				   (x (/ (+ (bits x (1- k) 0)
					    (bits y (1- k) 0))
					 (expt 2 k))))
			(:instance fl-def-linear
				   (x (/ (+ (bits x (1- k) 0)
					    (bits y (1- k) 0))
					 (expt 2 k))))))))

(local-defthm sticky-21-5
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (member (fl (/ (+ (bits x (1- k) 0)
			       (bits y (1- k) 0))
			    (expt 2 k)))
		     '(0 1)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-4))))

(local-defthm sticky-21-6
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (member (+ (bits x (1- k) 0)
			(bits y (1- k) 0))
		     (list (expt 2 k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use (sticky-21-5
			sticky-21-1
			(:instance quot-rem
				   (m (+ (bits x (1- k) 0)
					 (bits y (1- k) 0)))
				   (n (expt 2 k)))))))

(local-defthm hack-6
    (implies (and (natp k)
		  (>= k 2))
	     (natp (expt 2 (- k 2))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp))))

(local-defthm sticky-21-7
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (= (bitn x (1- k)) 0)
		  (= (bitn y (1- k)) 0))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bits-rem)
		  :use (sticky-21-6
			hack-6
			(:instance bits-plus-bitn (n (1- k)) (m 0))
			(:instance bits-plus-bitn (x y) (n (1- k)) (m 0))
			(:instance rem-bnd-1 (m x) (n (expt 2 (1- k))))
			(:instance rem-bnd-1 (m y) (n (expt 2 (1- k))))))))

(local-defthm hack-7
    (implies (and (natp k)
		  (>= k 2))
	     (> (expt 2 (- k 2)) 0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp))))

(local-defthm hack-8
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2))
	     (not (EQUAL (+ (* 2 (EXPT 2 (+ -2 K)))
			    (+ (BITS Y (+ -2 K) 0)
			       (* 2 (EXPT 2 (+ -2 K))
				  (BITN Y (+ -1 K))))
			    (BITS X (+ -2 K) 0))
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (union-theories (disable natp-bits) '(natp))
		  :use (hack-7
			(:instance bitn-0-1 (x y) (n (1- k)))
			(:instance natp-bits (i (- k 2)) (j 0))
			(:instance natp-bits (i (- k 2)) (j 0) (x y))))))

(local-defthm hack-9
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2))
	     (not (EQUAL (+ (BITS X (+ -1 K) 0)
			    (* 2 (EXPT 2 (+ -2 K)))
			    (BITS Y (+ -2 K) 0))
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (union-theories (disable natp-bits) '(natp))
		  :use (hack-7
			(:instance bitn-0-1 (x y) (n (1- k)))
			(:instance natp-bits (i (- k 1)) (j 0))
			(:instance natp-bits (i (- k 2)) (j 0) (x y))))))

(local-defthm sticky-21-8-2
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (>= k 2)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (or (= (bitn x (1- k)) 1)
		      (= (bitn y (1- k)) 1)))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-6
			hack-8
			hack-9
			(:instance bits-plus-bitn (n (1- k)) (m 0))
			(:instance bits-plus-bitn (x y) (n (1- k)) (m 0))))))

(local-defthm bitn+0
    (implies (and (natp x)
		  (natp y))
	     (= (bitn (+ x y) 0)
		(bitn (+ (bitn x 0) (bitn y 0)) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-rec-0)
		  :use ((:instance rem-sum (a (bitn x 0)) (b y) (n 2))
			(:instance rem-sum (a y) (b x) (n 2))))))

(local-defthm sticky-21-8-1
    (implies (and (natp x)
		  (natp y)
		  (= (bits (+ x y) 0 0) 0)
		  (or (= (bitn x 0) 1)
		      (= (bitn y 0) 1)))
	     (equal (+ (bits x 0 0)
		       (bits y 0 0))
		    2))
    :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite)
		  :use (bitn+0
			(:instance bitn-0-1 (n 0))
			(:instance bitn-0-1 (x y) (n 0))))))

(local-defthm sticky-21-8
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0)
		  (or (= (bitn x (1- k)) 1)
		      (= (bitn y (1- k)) 1)))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-8-2
			sticky-21-8-1))))

(local-defthm sticky-21-9
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (+ (bits x (1- k) 0)
		       (bits y (1- k) 0))
		    (* (expt 2 k)
		       (logior (bitn y (1- k))
			       (bitn x (1- k))))))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-7
			sticky-21-8
			(:instance bitn-0-1 (n (1- k)))
			(:instance bitn-0-1 (x y) (n (1- k)))))))

(defthm bits-shift-5
    (implies (and (natp x)
		  (natp k)
		  (natp i))
	     (equal (* (expt 2 k) (bits x i 0))
		    (bits (* (expt 2 k) x) (+ i k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp bits-rem)
		  :use ((:instance expo+ (n k) (m (1+ i)))
			(:instance rem-prod (k (expt 2 k)) (m x) (n (expt 2 (1+ i))))))))

(local-defthm sticky-21-10
    (implies (and (natp x)
		  (natp y)

		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (bits (+ (bits x n 0) (bits y n 0))
			  n 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable rem-sum bits-rem)
		  :use ((:instance bits-plus-bits (x (+ x y)) (m (1+ n)) (n k) (r 0))
			(:instance rem-rem-sum (a x) (b y) (n (expt 2 k)))))))

(local-defthm sticky-21-11
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (bits (* (expt 2 k)
			     (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k)))))
			  n 0)))
  :rule-classes ()
  :hints (("Goal" :use (sticky-21-10
			sticky-21-9
			(:instance bits-plus-bits (m (1+ n)) (n k) (r 0))
			(:instance bits-plus-bits (x y) (m (1+ n)) (n k) (r 0))))))

(local-defthm sticky-21-12
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (* (expt 2 k) (bits (+ x y) n k))
		    (* (expt 2 k)
		       (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
			     (- n k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (sticky-21-11
			(:instance bits-shift-5
				   (x (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k)))))
				   (i (- n k)))))))

(local-defthm sticky-21
    (implies (and (natp x)
		  (natp y)
		  (natp k)
		  (> k 0)
		  (natp n)
		  (>= n k)
		  (= (bits (+ x y) (1- k) 0) 0))
	     (equal (bits (+ x y) n k)
		    (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
			  (- n k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (sticky-21-12
			(:instance cancel-equal-*
				   (a (expt 2 k))
				   (r (bits (+ x y) n k))
				   (s (bits (+ (bits x n k) (bits y n k) (logior (bitn x (1- k)) (bitn y (1- k))))
					    (- n k) 0)))))))

(defthm bits-sum-0
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0)
		  (= (bits (+ x y) (1- j) 0) 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i j) (bits y i j) (logior (bitn x (1- j)) (bitn y (1- j))))
			  (- i j) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance sticky-21 (n i) (k j))))))

(defthm exact-k+1
    (implies (and (natp n)
		  (natp x)
		  (= (expo x) (1- n))
		  (natp k)
		  (< k (1- n))
		  (exactp x (- n k)))
	     (iff (exactp x (1- (- n k)))
		  (= (bitn x k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable exactp2 exactp2-lemma)
           :use (exact-bits-b-d
			(:instance exact-bits-b-d (k (1+ k)))
			(:instance bits-0-bitn-0 (n k))))))

(local-defthm bits-sum-1
    (implies (and (natp x)
		  (natp y)
		  (natp j)
		  (> j 0))
	     (equal (BITS (+ (BITS X (+ -1 J) 0)
			     (BITS Y (+ -1 J) 0))
			  J 0)
		    (+ (BITS X (+ -1 J) 0)
		       (BITS Y (+ -1 J) 0))))
  :hints (("Goal" :in-theory (union-theories (disable bvecp-bits) '(natp bvecp))
		  :use ((:instance bvecp-bits (i (1- j)) (j 0) (n j))
			(:instance bvecp-bits (x y) (i (1- j)) (j 0) (n j))
			(:instance bits-tail (x (+ (BITS X (+ -1 J) 0) (BITS Y (+ -1 J) 0))) (n j))))))

(local-defthm bits-sum-2
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (+ (bits x i 0)
		       (bits y i 0))
		    (+ (* (expt 2 j)
			  (+ (bits x i j)
			     (bits y i j)
			     (bitn (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   j)))
		       (bits (+ (bits x (1- j) 0)
				(bits y (1- j) 0))
			     (1- j)
			     0))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bits-plus-bits (m (1+ i)) (n j) (r 0))
			(:instance bits-plus-bits (x y) (m (1+ i)) (n j) (r 0))
			(:instance bits-plus-bitn (x (+ (bits x (1- j) 0) (bits y (1- j) 0))) (n j) (m 0))))))

(local-defthm bits-sum-3
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (rem (+ (bits x i 0)
			    (bits y i 0))
			 (expt 2 (1+ i)))
		    (rem (+ x y)
			 (expt 2 (1+ i)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable rem-sum bits-rem)
		  :use ((:instance rem-sum (a (bits x i 0)) (b y) (n (expt 2 (1+ i))))
			(:instance rem-sum (a x) (b y) (n (expt 2 (1+ i))))))))

(local-defthm bits-sum-4
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i 0)
			     (bits y i 0))
			  i j)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-3
			(:instance rem-bits-equal (x (+ x y)) (y (+ (bits x i 0) (bits y i 0))))))))

(local-defthm bits-sum-5
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (* (expt 2 j)
				(+ (bits x i j)
				   (bits y i j)
				   (bitn (+ (bits x (1- j) 0)
					    (bits y (1- j) 0))
					 j)))
			     (bits (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   (1- j)
				   0))
			  i j)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-4 bits-sum-2))))

(local-defthm bits-sum-6
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (< (bits (+ (bits x (1- j) 0)
			 (bits y (1- j) 0))
		      (1- j)
		      0)
		(expt 2 j)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use ((:instance rem-bnd-1 (m (+ (bits x (1- j) 0) (bits y (1- j) 0))) (n (expt 2 j)))))))

(defthm bits-sum
    (implies (and (natp x)
		  (natp y)
		  (natp i)
		  (natp j)
		  (>= i j)
		  (> j 0))
	     (equal (bits (+ x y) i j)
		    (bits (+ (bits x i j)
			     (bits y i j)
			     (bitn (+ (bits x (1- j) 0)
				      (bits y (1- j) 0))
				   j))
			  (- i j) 0)))
  :rule-classes ()
  :hints (("Goal" :use (bits-sum-5 
			bits-sum-6
			(:instance bits-plus-mult
				   (x (bits (+ (bits x (1- j) 0)
					       (bits y (1- j) 0))
					    (1- j)
					    0))
				   (y (+ (bits x i j)
					 (bits y i j)
					 (bitn (+ (bits x (1- j) 0)
						  (bits y (1- j) 0))
					       j)))
				   (k j)
				   (n i)
				   (m j))))))

(local-defthm stick-lemma-3-1
    (implies (and (natp a)
		  (natp b)
		  (natp k))
	     (equal (bits (+ a b 1) k 0)
		    (bits (+ (bits a k 0)
			     (bits b k 0)
			     1)
			  k 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use ((:instance rem-sum (a (1+ (bits a k 0))) (n (expt 2 (1+ k))))
			(:instance rem-sum (a (1+ b)) (b a) (n (expt 2 (1+ k))))))))

(in-theory (disable comp1))

(local-defthm stick-lemma-3-2
    (implies (and (natp n)
		  (natp k)
		  (natp j)
		  (< k n)
		  (<= j k)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bits (comp1 (logxor a b) n) k j)
		    (comp1 (logxor (bits a k j) (bits b k j)) (1+ (- k j)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-comp1 bits-logxor bvecp-logxor))))

(local-defthm stick-lemma-3-3
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bitn (comp1 (logxor a b) n) k)
		    (comp1 (logxor (bitn a k) (bitn b k)) 1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite bvecp-logxor bvecp-comp1)
		  :use ((:instance stick-lemma-3-2 (j k))))))

(local-defthm stick-lemma-3-4
    (implies (and (natp n)
		  (> n 0)
		  (bvecp a n)
		  (bvecp b n))
	     (equal (bits (+ a b 1) 0 0)
		    (bits (comp1 (logxor a b) n) 0 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite bvecp-logxor bvecp-comp1)
		  :use ((:instance stick-lemma-3-1 (k 0))
			(:instance stick-lemma-3-2 (k 0) (j 0))
			(:instance bitn-0-1 (x a) (n 0))
			(:instance bitn-0-1 (x b) (n 0))))))

(local-defthm stick-lemma-3-5
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (iff (equal (bits (+ a b 1) (1- k) 0)
			      0)
		       (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			      0))
		  (not (equal (bits (+ a b 1) (1- k) 0) 0)))
	     (iff (equal (bits (+ a b 1) k 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) k 0)
			 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp-logxor bvecp-comp1)
		  :use ((:instance bits-plus-bitn
				   (x (comp1 (logxor a b) n))
				   (n k)
				   (m 0))
			(:instance bits-plus-bitn
				   (x (+ a b 1))
				   (n k)
				   (m 0))
			(:instance bits-0-bitn-0
				   (x (comp1 (logxor a b) n))
				   (n k))
			(:instance bits-0-bitn-0
				   (x (+ a b 0))
				   (n k))))))
;move up?
(defthm bvecp<=
    (implies (and (natp n)
		  (bvecp x n))
	     (<= x (1- (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp))))

(local-defthm stick-lemma-3-6
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (< (+ (bits a (1- k) 0) (bits b (1- k) 0) 1)
		(* 2 (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bvecp<= (x (bits a (1- k) 0)) (n k))
			(:instance bvecp<= (x (bits b (1- k) 0)) (n k))))))

(local-defthm stick-lemma-3-7
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (+ (bits a (1- k) 0) (bits b (1- k) 0) 1)
		(expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-rem)
		  :use (stick-lemma-3-6
			(:instance stick-lemma-3-1 (k (1- k)))
			(:instance rem-must-be-n
				   (m (+ (bits a (1- k) 0) (bits b (1- k) 0) 1))
				   (n (expt 2 k)))))))

(defthm bits-plus-bitn-rewrite
    (implies (and (natp x)
		  (natp m)
		  (natp n)
		  (> n m))
	     (equal (bits x n m)
		    (+ (* (bitn x n) (expt 2 (- n m)))
		       (bits x (1- n) m))))
  :hints (("Goal" :use (bits-plus-bitn))))


(local-defthm stick-lemma-3-8
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (bits (+ a b 1) k 0)
		(bits (* (expt 2 k) (+ (bitn a k) (bitn b k) 1)) k 0)))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-7
			stick-lemma-3-1))))

(in-theory (disable bits-plus-bitn-rewrite))

(local-defthm stick-lemma-3-9
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (= (bits (+ a b 1) k 0)
		(* (expt 2 k) 
		   (bits (+ (bitn a k) (bitn b k) 1) 0 0))))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-8
			(:instance bits-shift-5 (x (+ (bitn a k) (bitn b k) 1)) (i 0))))))

(local-defthm stick-lemma-3-10
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (+ (bitn a k) (bitn b k) 1) 0 0) 0)))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-9))))

(local-defthm stick-lemma-3-11
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (comp1 (logxor (bits a k k) (bits b k k)) 1) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite)
		  :use (stick-lemma-3-10
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))))))

(local-defthm stick-lemma-3-12
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (comp1 (logxor a b) n) k k) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bits-comp1 bits-logxor bvecp-comp1 bvecp-logxor)
		  :use (stick-lemma-3-11))))

(defthm comp1-bitn
    (implies (and (natp m) 
		  (natp n) 
		  (> m n)
		  (bvecp x m))
	     (equal (bitn (comp1 x m) n)
		    (comp1 (bitn x n) 1)))
  :hints (("Goal" :in-theory (enable bits-n-n-rewrite)
		  :use (:instance bits-comp1 (i n) (j n)))))

(in-theory (disable comp1-bitn))

(local-defthm stick-lemma-3-13
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (equal (bits (+ a b 1) (1- k) 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			 0))
	     (iff (= (bits (+ a b 1) k 0) 0)
		  (= (bits (comp1 (logxor a b) n) k 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable logxor-bitn comp1-bitn bits-n-n-rewrite bits-comp1 bits-logxor bvecp-comp1 bvecp-logxor)
		  :use (stick-lemma-3-12
			(:instance bits-0-bitn-0
				   (x (comp1 (logxor a b) n))
				   (n k))))))

(local-defthm stick-lemma-3-14
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (< 0 k)
		  (bvecp a n)
		  (bvecp b n)
		  (iff (equal (bits (+ a b 1) (1- k) 0)
			      0)
		       (equal (bits (comp1 (logxor a b) n) (1- k) 0)
			      0)))
	     (iff (equal (bits (+ a b 1) k 0)
			 0)
		  (equal (bits (comp1 (logxor a b) n) k 0)
			 0)))
  :rule-classes ()
  :hints (("Goal" :use (stick-lemma-3-5
			stick-lemma-3-13))))


(defthm top-thm-1
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (bvecp a n)
		  (bvecp b n))
	     (iff (= (bits (+ a b 1) k 0)
		     0)
		  (= (bits (comp1 (logxor a b) n) k 0)
		     0)))
  :rule-classes ()
  :hints (("Goal" :induct (natp-induct k))
	  ("Subgoal *1/2" :use stick-lemma-3-14)
	  ("Subgoal *1/1" :use stick-lemma-3-4)))

(in-theory (enable bvecp-comp1 bvecp-logand bvecp-logior bvecp-logxor))

;moved bitn-bvecp-1 to merge



(defthm comp1-fl-rewrite
    (implies (and (not (zp n))
		  (bvecp x n))
	     (equal (fl (* 1/2 (comp1 x n)))
		    (comp1 (fl (* 1/2 x)) (1- n))))
  :hints (("Goal" :use ((:instance comp1-fl (k 1))))))

(defthm comp1-rem-2
    (implies (and (not (zp n))
		  (bvecp x n))
	     (equal (rem (comp1 x n) 2)
		    (comp1 (rem x 2) 1)))
  :hints (("Goal" :use (rem-comp1-2
			rem-mod-2
			(:instance rem-mod-2 (x (comp1 x n)))))))

(in-theory (disable comp1-fl-rewrite comp1-rem-2))

(in-theory (enable bvecp-logxor))

(local-defthm comp1-logxor-1
    (implies (and (not (zp n))
		  (bvecp x n)
		  (bvecp y n)
		  (equal (comp1 (logxor (fl (/ x 2)) (fl (/ y 2))) (1- n))
			 (logxor (comp1 (fl (/ x 2)) (1- n)) (fl (/ y 2)))))
	     (equal (comp1 (logxor x y) n)
		    (logxor (comp1 x n) y)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable logand-rem-2 logxor-rem-2 comp1-rem-2 bvecp-comp1
				     comp1-fl-rewrite logand-fl-2-rewrite logxor-fl-2-rewrite)
		  :use (rem-mod-2
			(:instance rem-mod-2 (x y))
			(:instance quot-rem (m (comp1 (logxor x y) n)) (n 2))
			(:instance quot-rem (m (logxor (comp1 x n) y)) (n 2))))))

(defun logop2-induct (x y n)
  (if (zp n)
      (cons x y)
    (logop2-induct (fl (/ x 2)) (fl (/ y 2)) (1- n))))

;move up?
(defthm bvecp-fl
    (implies (and (not (zp n))
		  (bvecp x n))
	     (bvecp (fl (* 1/2 x)) (1- n)))
  :hints (("Goal" :in-theory (enable bvecp))))

(local-defthm bvecp-0
    (implies (bvecp x 0) (equal x 0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm comp1-logxor
    (implies (and (natp n)
		  (bvecp x n)
		  (bvecp y n))
	     (equal (comp1 (logxor x y) n)
		    (logxor (comp1 x n) y)))
  :hints (("Goal" :induct (logop2-induct x y n))
	  ("Subgoal *1/2" :use (comp1-logxor-1))
	  ("Subgoal *1/1" :use (bvecp-0
				(:instance bvecp-0 (x y))))))

(in-theory (disable comp1-logxor))



;moved drnd stuff to rnd
;(in-theory (disable rnd))


;(in-theory (disable ieee-mode-p flip))

;moved expo-x+2**k





(defthm bitn-rec-pos-def
    (implies (and (natp x)
		  (natp k)
		  (> k 0))
	     (equal (bitn x k)
		    (bitn (fl (/ x 2)) (1- k))))
  :rule-classes ((:definition :controller-alist ((bitn t t))))
  :hints (("Goal" :by bitn-rec-pos)))

(in-theory (disable bitn-rec-pos-def))

(defthm logior-x-1
    (implies (bvecp x 1)
	     (equal (logior x 1) 1))
  :hints (("Goal" :use ((:instance logior-ones (n 1))))))

(defthm logior-1-x
    (implies (bvecp x 1)
	     (equal (logior 1 x) 1))
    :hints (("Goal" :use ((:instance logior-commutative (y 1))))))


;move to float? ;rephrase?
(defthm exactp-shift-iff
    (implies (and (rationalp x)
		  (integerp m)
		  (integerp n))
	     (iff (exactp x m)
		  (exactp (* (expt 2 n) x) m)))
  :rule-classes ()
  :hints (("Goal" :use (exactp-shift
			(:instance exactp-shift (x (* (expt 2 n) x)) (n (- n)))))))



;move to basic


(defthm natp-rem
  (implies (and (natp m)
                (natp n))
           (natp (rem m n)))
  :rule-classes :type-prescription
  :hints (("Goal" :use rem>=0)))

(defthm integerp-rationalp
    (implies (integerp x)
	     (rationalp x)))

;move to wherever bvecp is defined
(defthm natp-bvecp
    (implies (bvecp x n)
	     (natp x)))




;moved bvecp-exactp to merge.lisp


(defthm exact-bits-1
    (implies (and (natp x)
		  (natp n)
		  (natp k)
		  (= (expo x) (1- n))
		  (< k n))
	     (iff (integerp (/ x (expt 2 k)))
		  (exactp x (- n k))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use exact-bits-a-b)))

(defthm exact-bits-2
    (implies (and (natp x)
		  (natp n)
		  (natp k)
		  (= (expo x) (1- n))
		  (< k n))
	     (iff (integerp (/ x (expt 2 k)))
		  (= (bits x (1- n) k)
		     (/ x (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use exact-bits-a-c)))

(defthm exact-bits-3
    (implies (and (natp x)
		  (natp n)
		  (natp k)
		  (= (expo x) (1- n))
		  (< k n))
	     (iff (integerp (/ x (expt 2 k)))
		  (= (bits x (1- k) 0)
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use exact-bits-a-d)))

(defthm expt+
    (implies (and (integerp n)
		  (integerp m))
	     (= (* (expt 2 m) (expt 2 n))
		(expt 2 (+ m n))))		
  :rule-classes ()
  :hints (("Goal" :use expo+)))

;removed expt-weak-monotone

(defthm logior-0-y
    (implies (natp y)
	     (equal (logior 0 y) y)))

(local
(defthm logior-x-x-1
    (implies (and (integerp x) (>= x 0))
	     (equal (logior (rem x 2) (rem x 2)) (rem x 2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem-mod-2))))))

(local
 (defthm fl-rem-equal
    (implies (and (integerp x) (>= x 0)
		  (integerp y) (>= y 0)
		  (= (fl (/ x 2)) (fl (/ y 2)))
		  (= (rem x 2) (rem y 2)))
	     (= x y))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem-fl (m x) (n 2))
			(:instance rem-fl (m y) (n 2)))))))

(defun logop-2-induct (x y)
  (if (or (zp x) (zp y))
      ()
    (logop-2-induct (fl (/ x 2)) (fl (/ y 2)))))

(defthm logior-self
    (implies (natp x)
	     (equal (logior x x) x))
  :hints (("Goal" :induct (logop-2-induct x x))
	  ("Subgoal *1/2" :in-theory (enable logior-rewrite)
			  :use ((:instance logior-x-x-1)
				(:instance fl-rem-equal (y (logior x x)))))))

(defun logop-2-n-induct (x y n)
  (if (zp n)
      (cons x y)
    (logop-2-n-induct (fl (/ x 2)) (fl (/ y 2)) (1- n))))


(defthm logior-x-1
    (implies (bvecp x 1)
	     (equal (logior x 1) 1))
  :hints (("Goal" :in-theory (enable bvecp-1-rewrite))))


;moved stuff to merge

#| redundant
(defthm bitn-bvecp-1
    (implies (bvecp x 1)
	     (equal (bitn x 0) x))
  :hints (("Goal" :in-theory (enable bvecp-1-rewrite))))
|#


(defthm roundup-1
    (implies (and (integerp x)
		  (integerp k))
	     (equal (bitn (* X (EXPT 2 K) (EXPT 2 (* -1 K))) n)
		    (bitn x n)))
  :rule-classes ())

(defthm roundup-2
    (implies (and (natp x)
		  (natp (* x (expt 2 k)))
		  (natp n)
		  (natp (+ n k))
		  (integerp k)
		  (<= k 0))
	     (= (bitn (* x (expt 2 k)) (+ n k))
		(bitn x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use ((:instance bitn-shift (x (* x (expt 2 k))) (n (+ n k)) (k (- k)))))
	  ("Goal'''" :use (roundup-1))))

(defthm bitn-shift-gen
    (implies (and (natp x)
		  (natp (* x (expt 2 k)))
		  (natp n)
		  (natp (+ n k))
		  (integerp k))
	     (= (bitn (* x (expt 2 k)) (+ n k))
		(bitn x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use (bitn-shift
			roundup-2))))

(defun mulcat (l n x)
  (if (and (integerp n) (> n 0))
      (cat (mulcat l (1- n) x)
	   x
	   l)
    0))

(defthm mulcat-1
    (implies (and (natp x)
		  (natp l))
	     (equal (mulcat l 1 x) x))
  :hints (("Goal" :in-theory (enable mulcat cat-0-rewrite)
		  :expand ((mulcat l 1 x)))))

(local-defthm mulcat-hack
    (implies (and (natp n)
		  (natp l)
		  (<= 1 n))
	     (not (< (* l n) l)))
  :hints (("Goal" :in-theory (enable natp))))

(defthm bvecp-mulcat
    (implies (and (natp n)
		  (natp l)
		  (bvecp x l)
		  (= p (* l n)))
	     (bvecp (mulcat l n x) p))
  :hints (("Subgoal *1/2" :in-theory (disable bvecp-cat)
			  :use ((:instance bvecp-cat (x (mulcat l (1- n) x)) (y x) (n l) (p (* l n)))))))

(defthm logior-1-x
    (implies (bvecp x 1)
	     (equal (logior 1 x) 1))
  :hints (("Goal" :in-theory (enable bvecp-1-rewrite))))

(defthm logand-1-x
    (implies (bvecp x 1)
	     (equal (logand 1 x) x))
  :hints (("Goal" :in-theory (enable bvecp-1-rewrite))))

(defthm logand-x-1
    (implies (bvecp x 1)
	     (equal (logand x 1) x))
  :hints (("Goal" :in-theory (enable bvecp-1-rewrite))))




;;These go in the CAT section of "lib/bits.lisp":

(defthm cat-bits-bits
    (implies (and (natp x)
		  (natp i)
		  (natp j)
		  (natp k)
		  (natp l)
		  (>= i j)
		  (= j (1+ k))
		  (>= k l)
		  (= n (1+ (- k l))))
	     (equal (cat (bits x i j) (bits x k l) n)
		    (bits x i l)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable cat)
                              ;; Some change during the development of ACL2
                              ;; Version 2.6, probably the change in
                              ;; assume-true-false, required the following to
                              ;; be disabled.
                              '(rearrange-negative-coefs-<))
		  :use ((:instance bits-plus-bits (m (1+ i)) (n j) (r l))))))

(defthm cat-bitn-bits
    (implies (and (natp x)
		  (natp j)
		  (natp k)
		  (natp l)
		  (= j (1+ k))
		  (>= k l)
		  (= n (1+ (- k l))))
	     (equal (cat (bitn x j) (bits x k l) n)
		    (bits x j l)))
  :hints (("Goal" :in-theory (enable cat)
		  :use ((:instance bits-plus-bitn (n j) (m l))
			(:instance expt+ (n (- k l)) (m 1))))))

(defthm cat-bits-bitn
    (implies (and (natp x)
		  (natp i)
		  (natp j)
		  (natp k)
		  (>= i j)
		  (= j (1+ k)))
	     (equal (cat (bits x i j) (bitn x k) 1)
		    (bits x i k)))
  :hints (("Goal" :in-theory (enable cat)
		  :use ((:instance bitn-plus-bits (n i) (m k))))))

(defthm mulcat-1
    (implies (and (natp x)
		  (natp l))
	     (equal (mulcat l 1 x) x))
  :hints (("Goal" :in-theory (enable mulcat cat-0-rewrite)
		  :expand ((mulcat l 1 x)))))

(defthm mulcat-0
    (implies (and (natp l) (natp n))
	     (equal (mulcat l n 0) 0))
  :hints (("Goal" :in-theory (enable cat mulcat))))

(defthm mulcat-n-1
    (implies (and (integerp n) (> n 0))
	     (equal (mulcat 1 n 1)
		    (1- (expt 2 n))))
  :hints (("Goal" :in-theory (enable cat mulcat))))



