(in-package "ACL2")

(local (include-book "bits2"))
(local (include-book "setbits2"))
(local (include-book "setbitn"))
(local (include-book "encode"))
(local (include-book "decode"))
(local (include-book "logs"))
(local (include-book "comp1"))
(local (include-book "bitn"))
(local (include-book "shft"))
(local (include-book "cat"))
(local (include-book "merge"))
(local (include-book "mulcat"))

(include-book "rtl")
(include-book "bvecp-lemmas")

;would like to remove some of this stuff

;what's this for?
(defconst *bvecp-logops*
  '(log< log<= log> log>= log= log<> logand1 logior1
         comp1 bitn bits shft cat mulcat setbits
         logand logior logxor
         ;; lognot ; should leave enabled -- why???
         mod-))

#|
;drop?
(DEFTHM BITS-bvecp-FW
  (IMPLIES (EQUAL N (- (1+ I) J))
           (BVECP (BITS X I J) N))
  :RULE-CLASSES
  ((:FORWARD-CHAINING :TRIGGER-TERMS ((BITS X I J)))))
|#



#|
;drop?
(defthm natp-logand-alterate
  (implies (and (bvecp x n)
                (bvecp y n)
                (integerp n)
                (<= 0 n))
           (and (integerp (logand x y))
                (<= 0 (logand x y))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :use bvecp-logand-alternate
           :in-theory '(implies bvecp))))
|#


#|
;free var n (x and y could be bvecps of different lengths)
(defthm natp-logior-alternate
  (implies (and (bvecp x n)
                (bvecp y n)
                (integerp n)
                (<= 0 n))
           (and (integerp (logior x y))
                (<= 0 (logior x y))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :use bvecp-logior-alternate
           :in-theory '(implies bvecp))))
|#


#|
;drop?
(defthm natp-logxor-alternate
  (implies (and (bvecp x n)
                (bvecp y n)
                (integerp n)
                (<= 0 n))
           (and (integerp (logxor x y))
                (<= 0 (logxor x y))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :use bvecp-logxor-alternate
           :in-theory '(implies bvecp))))
|#



;;;;;;;;;;;;;;;;;;; other helpful lemmas

(defthm nonneg-+
  (implies (and (<= 0 x)
                (<= 0 y))
           (<= 0 (+ x y))))

(defthm integerp-+
  (implies (and (integerp x)
                (integerp y))
           (integerp (+ x y))))


;remove these?


;;;;;;;;;;;;;;;;;;; We can probably eliminate the following if the translator
;;;;;;;;;;;;;;;;;;; would always use 0 instead of nil when case/casex
;;;;;;;;;;;;;;;;;;; statements have no default.

;maybe leave this one?

#|
(defthm bvecp-1-values
  (implies (and (bvecp x 1)
                (not (equal x 0)))
           (equal (equal x 1) t))
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm bvecp-2-values
  (implies (and (bvecp x 2)
                (not (equal x 2))
                (not (equal x 1))
                (not (equal x 0)))
           (equal (equal x 3) t))
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm bvecp-3-values
  (implies (and (bvecp x 3)
                (not (equal x 6))
                (not (equal x 5))
                (not (equal x 4))
                (not (equal x 3))
                (not (equal x 2))
                (not (equal x 1))
                (not (equal x 0)))
           (equal (equal x 7) t))
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm bvecp-4-values
  (implies (and (bvecp x 4)
                (not (equal x 14))
                (not (equal x 13))
                (not (equal x 12))
                (not (equal x 11))
                (not (equal x 10))
                (not (equal x 9))
                (not (equal x 8))
                (not (equal x 7))
                (not (equal x 6))
                (not (equal x 5))
                (not (equal x 4))
                (not (equal x 3))
                (not (equal x 2))
                (not (equal x 1))
                (not (equal x 0)))
           (equal (equal x 15) t))
  :hints (("Goal" :in-theory (enable bvecp))))

(defthm bvecp-5-values
  (implies (and (bvecp x 5)
                (not (equal x 30))
                (not (equal x 29))
                (not (equal x 28))
                (not (equal x 27))
                (not (equal x 26))
                (not (equal x 25))
                (not (equal x 24))
                (not (equal x 23))
                (not (equal x 22))
                (not (equal x 21))
                (not (equal x 20))
                (not (equal x 19))
                (not (equal x 18))
                (not (equal x 17))
                (not (equal x 16))
                (not (equal x 15))
                (not (equal x 14))
                (not (equal x 13))
                (not (equal x 12))
                (not (equal x 11))
                (not (equal x 14))
                (not (equal x 13))
                (not (equal x 12))
                (not (equal x 11))
                (not (equal x 10))
                (not (equal x 9))
                (not (equal x 8))
                (not (equal x 7))
                (not (equal x 6))
                (not (equal x 5))
                (not (equal x 4))
                (not (equal x 3))
                (not (equal x 2))
                (not (equal x 1))
                (not (equal x 0)))
           (equal (equal x 31) t))
  :hints (("Goal" :in-theory (enable bvecp))))
|#




;killed rationalp-cat and rationalp-comp1

;t-p rule?

(defthm bvecp-implies-natp
  (implies (bvecp x k)
           (and (integerp x)
                (>= x 0)))
  :hints (("Goal" :in-theory (enable bvecp)))
  )

;t-p rule?
;free var
(defthm bvecp-implies-rationalp
  (implies (bvecp x k)
           (rationalp x))
  :hints (("Goal" :in-theory (enable bvecp)))
)


#|
;can remove these two?
(defthm natp-* 
  (implies (and (integerp x)
                (>= x 0)
                (integerp y)
                (>= y 0))
           (and (integerp (* x y))
                (>= (* x y) 0))))

(defthm natp-+ 
  (implies (and (integerp x)
                (>= x 0)
                (integerp y)
                (>= y 0))
           (and (integerp (+ x y))
                (>= (+ x y) 0))))
|#


;what other RTL primitives are missing bvecp lemmas?


;(local (acl2-include-book "rtl/rel2/lib/top"))






#|

(defun check-array (name a dim1 dim2)
  (if (zp dim1)
      t
    (and (bvecp (aref1 name a (1- dim1)) dim2)
	 (check-array name a (1- dim1) dim2))))

(defthm check-array-lemma-1
    (implies (and (not (zp dim1))
		  (check-array name a dim1 dim2)
		  (natp i)
		  (< i dim1))
	     (bvecp (aref1 name a i) dim2))
  :rule-classes ())

(defthm check-array-lemma
    (implies (and (bvecp i n)
		  (not (zp (expt 2 n)))
		  (check-array name a (expt 2 n) dim2))		  
	     (bvecp (aref1 name a i) dim2))
  :rule-classes ()
  :hints (("Goal" :use ((:instance check-array-lemma-1 (dim1 (expt 2 n)))))))

|#



(DEFTHM UNKNOWN-upper-bound
  (< (UNKNOWN KEY SIZE N) (expt 2 size))
  :HINTS
  (("Goal" :use bvecp-unknown
    :IN-THEORY (set-difference-theories
                (ENABLE BVECP)
                '(bvecp-unknown))))
  :RULE-CLASSES
  (:REWRITE (:linear :trigger-terms ((UNKNOWN KEY SIZE N)))))

(defthm bv-arrp-implies-nonnegative-integerp
  (implies (bv-arrp obj size)
           (and (INTEGERP (ag index obj))
                (<= 0 (ag index obj))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :use (:instance
                        ag-maps-bv-arr-to-bvecp (a index) (r obj) (k size))
           :in-theory (set-difference-theories
                       (enable bvecp)
                       '(ag-maps-bv-arr-to-bvecp))))
  )

(local (in-theory (enable floor-fl)))
;(local (include-book "mod-expt"))

#| trying to admit bvecp.lisp without this...
;proved in setbits2.lisp
(defthm setbits-does-nothing
  (implies (and (case-split (integerp x))
                (case-split (<= 0 x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 j)) ;gen?
                (case-split (<= j i))
                )
           (equal (setbits x i j (bits x i j))
                  x))
  :hints (("Goal" :in-theory (enable expt-split setbits cat ash bits mod))))
|#





;These next two are for the bus unit bvecp lemmas.


;could use (local (in-theory (enable  expt-compare-with-double)))
;remove?
(defthm bits-does-nothing-hack
  (implies (and (< x (expt 2 i)) 
                (integerp x)
                (<= 0 x)
                (integerp i)
                (<= 0 i))
           (equal (BITS (* 2 x) i 0)
                  (* 2 x)))
  :hints (("Goal"           :use (:instance bits-tail (x (* 2 x)) (n i))
           :in-theory (set-difference-theories
                       (enable bvecp expt-split)
                       '( bits-tail)))
          ))

;remove?
(defthm bits-does-nothing-hack-2
  (implies (and (< x (expt 2 i)) 
                (integerp x)
                (<= 0 x)
                (integerp i)
                (<= 0 i))
           (equal (bits (+ 1 (* 2 x)) i 0)
                  (+ 1 (* 2 x))))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(bits-tail
                                ))
           :use (:instance bits-tail (x (+ 1 (* 2 x))) (n i))
           ))
  )


;; misc. elim some of this stuff?

(local
 (defthm x<expt-linear
   (implies (and (integerp x)
                 (<= 0 x))
            (< x (expt 2 x)))
   :hints (("Goal" :in-theory (enable expt)))
   :rule-classes :linear))

;drop?
(local
 (defthm nat-is-bvecp
   (implies (and (integerp x)
                 (<= 0 x))
            (bvecp x (1+ x)))
   :hints (("Goal" :in-theory (enable bvecp)))
   :rule-classes nil))

