(in-package "ACL2")

(local (include-book "ground-zero"))
(local (include-book "fp2"))

;works:
;(thm (integerp (denominator x)))
;denom of non-rat?

(defthm denominator-positive-integer-type-prescription
  (and (< 0 (denominator x))
       (integerp (denominator x)))
  :rule-classes (:type-prescription))

(defthm denominator-positive-rewrite
  (< 0 (denominator x))
  :rule-classes (:type-prescription))

;linear rule?

(defthm denominator-of-integer-is-one-rewrirte
  (implies (case-split (rationalp x))
           (equal (equal (denominator x) 1)
                  (integerp x)))
  :hints (("goal" :in-theory (disable rational-implies2)
           :use (rational-implies2
                 (:instance lowest-terms 
                            (n (denominator x))
                            (r x) 
                            (q 1))))))

(defthm denominator-of-integer-is-one
  (implies (integerp x)
           (equal (denominator x)
                  1)))

(encapsulate ()
             (local (include-book "../../../arithmetic/mod-gcd"))
             (defthm denominator-lower-bound
               (implies (and (< 0 q)
                             (integerp p)
                             (integerp q)
                             )
                        (<= (DENOMINATOR (* P (/ Q))) Q))
               :hints (("Goal" :use (:instance LEAST-numerator-denominator-<= (n p) (d q))))
               ))