(in-package "ACL2")

;(local (include-book "../../../meta/meta-times-equal"))
;(local (INCLUDE-BOOK "predicate"))
;(local (INCLUDE-BOOK "fp2"))

#|
treat constants separately.  careful.  do we prefer (equal x 1/2) or (equal (* 2 x) 1) ?
when this
 (+ 1 x (* 2 x) (* x y (/ z)))
 appears in an equality, we want to multiply through by z
either returns nil or a term to multiply through
this assumes the term is already normalized.  this will be the case if we call this function on, say (equal
lhs rhs) because by the time the equal term is processed, lhs and rhs are each individually nromalized

change the terminology to "inverted factor"

warning; multiplying through by these factors can cause problems with linear arithmetic (expand on this...)


binds the variable k
|#
(defun find-frac-coeff (term)
  (declare (xargs :guard (pseudo-termp term)))
  (if (not (consp term)) ;term was a symbol
      nil
    (case (car term)	
      (quote (if (integerp (cadr term)) 
                 nil ;no denominator
               (if (rationalp (cadr term))
                   `((k . ',(denominator (cadr term))))
                 nil)))
      (binary-+ (or (find-frac-coeff (cadr term))
                    (find-frac-coeff (caddr term))))
      (binary-* (or (find-frac-coeff (cadr term))
                    (find-frac-coeff (caddr term))))
      (unary-/ (list (cons 'k (cadr term)))) ;we found one!
      
      )))

;TERM is not a product containing FACTOR as a one factor
(defun not-a-factor (factor term)
  (declare (xargs :guard (pseudo-termp term)))
  (if (not (consp term)) ;term was a symbol
      t
    (case (car term)	
      (binary-* (if (equal factor (cadr term))
                    nil
                  (not-a-factor factor (caddr term))))
      (t t) ;anything else is not a prduct
      )))


;;
;; Detect that distributity and assoc rules have fired
;; doesn't check that comm and comm-2 have fired
;;


;terms must be something other than a call to * or +
;can be (/ x) since this normal form is before
(defun factor-syntaxp (term)
  (declare (xargs :guard (pseudo-termp term)))
  (if (not (consp term)) ;term was a symbol
      t
    (case (car term)	
      (quote t)
      (binary-* nil)
      (binary-+ nil) ;ensures dist fired
      (t t))))


;product must contain no call to binary-+
(defun product-syntaxp (term)
  (declare (xargs :guard (pseudo-termp term)))
  (if (not (consp term)) ;term was a symbol
      t
    (case (car term)	
      (binary-* (and (factor-syntaxp (cadr term))
                     (product-syntaxp (caddr term))))
      (t (factor-syntaxp term)))))


(defun sum-of-products-syntaxp (term)
  (declare (xargs :guard (pseudo-termp term)))
  (if (not (consp term)) ;term was a symbol
      t
    (case (car term)	
      (binary-+ (and (product-syntaxp (cadr term))
                     (sum-of-products-syntaxp (caddr term))))
      (t  (product-syntaxp term)))))



