(in-package "ACL2")

(local (include-book "fp2"))
(local (include-book "denominator"))
(local (include-book "numerator"))
(local (include-book "predicate"))
(local (include-book "unary-divide"))
(local (include-book "product"))
(local (include-book "integerp"))

;lemmas if non-rat args?


(defthm nonnegative-integer-quotient-with-a-non-integer-arg
  (implies (not (integerp i))
           (equal (nonnegative-integer-quotient i j)
                  0)))

(defthm nonnegative-integer-quotient-with-a-non-integer-arg-2
  (implies (not (integerp j))
           (equal (nonnegative-integer-quotient i j)
                  0)))


(defthm nonnegative-integer-quotient-with-a-non-positive-arg
  (implies (<= i 0)
           (equal (nonnegative-integer-quotient i j)
                  0)))

(defthm nonnegative-integer-quotient-with-a-non-positive-arg-2
  (implies (<= j 0)
           (equal (nonnegative-integer-quotient i j)
                  0)))

(defthm nonnegative-integer-quotient-upper-bound-rewrite
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
;                (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (<= (nonnegative-integer-quotient i j) (/ i j)))
  :hints (("Goal" :cases ((rationalp i))
           :in-theory (enable nonnegative-integer-quotient))))


(defthm nonnegative-integer-quotient-upper-bound-linear
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
;                (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (<= (nonnegative-integer-quotient i j) (/ i j)))
  :hints (("Goal" :cases ((rationalp i))
           :in-theory (enable nonnegative-integer-quotient)))
  :rule-classes ((:linear :trigger-terms ((nonnegative-integer-quotient i j)))))


#|
;what should the trigger terms be?
(defthm nonnegative-integer-quotient-upper-bound-2
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
;                (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (<= (* j (nonnegative-integer-quotient i j)) i))
  :hints (("Goal" :cases ((rationalp i))
           :in-theory (enable nonnegative-integer-quotient)))
  :rule-classes (:rewrite (:linear :trigger-terms ((nonnegative-integer-quotient i j)))))
|#

#|
(defthm nonnegative-integer-quotient-upper-bound-3
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
;                (case-split (rationalp i))
                (case-split (rationalp j))
                )
           (<= (* j (nonnegative-integer-quotient i j)) i))
  :hints (("Goal" :cases ((rationalp i))
           :in-theory (enable nonnegative-integer-quotient)))
  :rule-classes (:rewrite (:linear :trigger-terms ((* j (nonnegative-integer-quotient i j))))))
|#

(defthm nonnegative-integer-quotient-max-value-rewrite
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (equal (nonnegative-integer-quotient i j) (/ i j))
                  (integerp (/ i j)))))

(defthm nonnegative-integer-quotient-lower-bound-rewrite
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 i))
                (case-split (<= 0 j))
                )
           (< (+ -1 (/ i j)) (nonnegative-integer-quotient i j)))
)

(defthm nonnegative-integer-quotient-lower-bound-linear
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 i))
                (case-split (<= 0 j))
                )
           (< (+ -1 (/ i j)) (nonnegative-integer-quotient i j)))
  :rule-classes ( (:linear :trigger-terms ((nonnegative-integer-quotient i j)))))

#|
;what should the trigger terms be?
(defthm nonnegative-integer-quotient-lower-bound-2
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 i))
                (case-split (<= 0 j))
                (case-split (not (equal 0 j)))
                )
           (< (+ i (* -1 j)) (* j (nonnegative-integer-quotient i j))))
  :hints (("Goal" :in-theory (disable  nonnegative-integer-quotient-lower-bound)
           :use  nonnegative-integer-quotient-lower-bound))
  :rule-classes (:rewrite (:linear :trigger-terms ((nonnegative-integer-quotient i j)))))
|#

#|
(defthm nonnegative-integer-quotient-lower-bound-3
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 i))
                (case-split (<= 0 j))
                (case-split (not (equal 0 j)))
                )
           (< (+ i (* -1 j)) (* j (nonnegative-integer-quotient i j))))
  :hints (("Goal" :in-theory (disable  nonnegative-integer-quotient-lower-bound)
           :use  nonnegative-integer-quotient-lower-bound))
  :rule-classes (:rewrite (:linear :trigger-terms ((* j (nonnegative-integer-quotient i j))))))

|#

#|

         (<= (* J
                (NONNEGATIVE-INTEGER-QUOTIENT (NUMERATOR (* I (/ J)))
                                              (DENOMINATOR (* I (/ J)))))
             I)

|#


(defthm nonnegative-integer-quotient-upper-bound-linear-stronger
  (implies (and (case-split (<= 0 i))
                (case-split (<= 0 j))
                (NOT (INTEGERP (* I (/ J))))
                (case-split (acl2-numberp i))
                (case-split (rationalp j))
                (case-split (rationalp k))
                (case-split (< 0 k))
                )
           (< (* k (nonnegative-integer-quotient i j)) (* k (/ i j))))
  :hints (("Goal" :cases ((rationalp i))
           :in-theory (enable nonnegative-integer-quotient)))
  :rule-classes ((:linear :trigger-terms ((* k (nonnegative-integer-quotient i j))
                                          ))))


#|
(skip-proofs
 (defthm nonnegative-integer-quotient-upper-bound-linear-stronger
   (implies (and (case-split (<= 0 i))
                 (case-split (<= 0 j))
                 (NOT (INTEGERP (* I (/ J))))
                 (case-split (acl2-numberp i))
                 (case-split (rationalp j))
                 (case-split (rationalp k))
                 (case-split (< 0 k))
                 )
            (< (* k (nonnegative-integer-quotient i j)) (* k (/ i j))))
   :hints (("Goal" :cases ((rationalp i))
            :in-theory (enable nonnegative-integer-quotient)))
   :rule-classes ((:linear :trigger-terms ((* k (nonnegative-integer-quotient i j))))))
 )

(skip-proofs
(defthm integerp-minus
  (implies (rationalp x)
           (equal (integerp (* -1 x))
                  (integerp x))))
         )

|#

