#include "CalendarView.h"
#include "GNUstepGUI/GSDrawFunctions.h"

#define YEAR_POPUP_SIZE 3

@interface NSCalendarDate (isTheSameDay)
- (BOOL) isTheSameDay;
@end

@implementation NSCalendarDate (isTheSameDay)
- (BOOL) isTheSameDayAs:(NSCalendarDate *)date
{
}
@end

@interface CalendarCell : NSActionCell
{
	NSColor *_color;
	BOOL _isToday;
	int _selectMode;
}
- (void) setColor:(NSColor *)color;
- (void) setToday:(BOOL)isToday;
- (void) setSelectMode:(int)mode;
- (int) selectMode;
- (BOOL) isToday;
@end

@implementation CalendarCell

- (void) setColor:(NSColor *)color
{
	ASSIGN(_color, color);
}

- (int) selectMode
{
	return _selectMode;
}

- (void) setSelectMode:(int)mode
{
	_selectMode = mode;
}

- (void) setToday:(BOOL)isToday
{
	_isToday = isToday;
}

- (BOOL) isToday
{
	return _isToday;
}

- (void) drawInteriorWithFrame: (NSRect)cellFrame inView: (NSView*)controlView
{
	id <CalendarCell> ct;
	int row,col;
	NSRect wr;
	NSSize strSize;

	ct = [self target];

	NSMutableAttributedString *str = [[NSMutableAttributedString alloc]
		initWithString:[self stringValue]];
	NSColor *textColor;
	NSPoint center = NSMakePoint(NSMinX(cellFrame)+NSWidth(cellFrame)/2,
			NSMinY(cellFrame)+NSHeight(cellFrame)/2);

	[str addAttribute:NSFontAttributeName
				value:[NSFont systemFontOfSize:NSHeight(cellFrame)/1.5]
				range:NSMakeRange(0,[str length])];
	strSize = [str size];

	wr.size.width = NSWidth([controlView bounds]);
	wr.size.height = NSHeight(cellFrame);
	wr.origin.x = 0;
	wr.origin.y = NSMinY(cellFrame);

	[_color set];

	if (_isToday)
	{
		textColor = [NSColor controlLightHighlightColor];
	}
	else
	{
		textColor = [NSColor textColor];
	}

	[str addAttribute:NSForegroundColorAttributeName
				value:textColor
				range:NSMakeRange(0,[str length])];

	[str drawAtPoint:NSMakePoint(center.x-strSize.width/2,
			center.y-strSize.height/2)];
	RELEASE(str);
}
@end



@interface CalendarMatrix : NSMatrix
@end

@implementation CalendarMatrix

static void draw_calendar_bar (NSGraphicsContext *ctxt, NSRect lineRect)
{
	DPSmoveto(ctxt,
			NSMinX(lineRect) + NSHeight(lineRect)/2,
			NSMinY(lineRect));
	DPSlineto(ctxt,
			NSMaxX(lineRect) - NSHeight(lineRect)/2,
			NSMinY(lineRect));
	DPSarc(ctxt,
			NSMaxX(lineRect) - NSHeight(lineRect)/2,
			NSMinY(lineRect) + NSHeight(lineRect)/2,
			NSHeight(lineRect)/2,
			270,90);
	DPSlineto(ctxt,
			NSMinX(lineRect) + NSHeight(lineRect)/2,
			NSMinY(lineRect) + NSHeight(lineRect));
	DPSarc(ctxt,
			NSMinX(lineRect) + NSHeight(lineRect)/2,
			NSMinY(lineRect) + NSHeight(lineRect)/2,
			NSHeight(lineRect)/2,
			90,270);
}

- (void) drawRect:(NSRect)rect
{
	int i,j;
	float dsize;
	NSRect lineRect,cellRect;
	NSGraphicsContext *ctxt=GSCurrentContext();
	//NSLog(@"%@",NSStringFromRect(rect));
	[[NSColor controlBackgroundColor] set];
	NSRectFill(_bounds);

	[[NSColor textBackgroundColor] set];

	NSRectFill(_bounds);
	/*
	for (i = 1; i < _numRows; i++)
	{
		cellRect = [self cellFrameAtRow:i column:0];

		lineRect = cellRect;
		lineRect.size.width = NSWidth(_bounds);

		dsize = NSHeight(lineRect) * 0.05;

		lineRect.size.width -= dsize*2;
		lineRect.size.height -= dsize*2;
		lineRect.origin.x += dsize;
		lineRect.origin.y += dsize;

		draw_calendar_bar(ctxt, lineRect);
		DPSfill(ctxt);

	}
	*/

	[[NSColor darkGrayColor] set];

	/* now selected cell */
	
	for (i = 0; i < _numRows; i++)
	for (j = 0; j < _numCols; j++)
	{
		CalendarCell *cell;
		cell = [self cellAtRow:i column:j];
		cellRect = [self cellFrameAtRow:i column:j];
		
		if (j > 0 && [[self cellAtRow:i column:j-1] isHighlighted])
		{
		}
		else if ([cell isHighlighted])
		{
			int nw;
			lineRect = cellRect;

			for (nw = j; nw < _numCols; nw++)
			{
				if ([[self cellAtRow:i column:nw] isHighlighted])
				{
					lineRect = NSUnionRect(lineRect,
							[self cellFrameAtRow:i column:nw]);
				}
			}

			DPSgsave(ctxt);
			[[NSColor controlHighlightColor] set];

			DPSrectclip(ctxt, NSMinX(lineRect), NSMinY(lineRect),
					NSWidth(lineRect), NSHeight(lineRect));

			dsize = NSHeight(cellRect) * 0.1;
			lineRect.size.width -= dsize*2;
			lineRect.size.height -= dsize*2;
			lineRect.origin.x += dsize;
			lineRect.origin.y += dsize;

			draw_calendar_bar(ctxt, lineRect);
			DPSfill(ctxt);
			DPSgrestore(ctxt);
		}

		if ([cell isToday])
		{
			lineRect = cellRect;
			[[NSColor blueColor] set];

			dsize = NSHeight(lineRect) * 0.1;

			lineRect.size.width -= dsize*2;
			lineRect.size.height -= dsize*2;
			lineRect.origin.x += dsize;
			lineRect.origin.y += dsize;

			if ([cell isHighlighted])
			{
				lineRect.size.width -= dsize*2;
				lineRect.size.height -= dsize*2;
				lineRect.origin.x += dsize;
				lineRect.origin.y += dsize;
			}

			draw_calendar_bar(ctxt, lineRect);
			DPSfill(ctxt);
		}

		[cell drawInteriorWithFrame:cellRect inView:self];
	}
}

- (void) mouseDown: (NSEvent*)theEvent
{
	int row,column;
	NSPoint lastLocation = [self convertPoint:[theEvent locationInWindow]
									 fromView:nil];
	NSCell *aCell;
	unsigned eventMask = NSLeftMouseUpMask | NSLeftMouseDownMask
		| NSMouseMovedMask  | NSLeftMouseDraggedMask;
	NSPoint mouseLocation;
	NSRect mouseCellFrame;
	[self getRow: &row
		  column: &column
		forPoint: lastLocation];
	NSLog(@"mouse down %@ %@",NSStringFromPoint(lastLocation),[[self cellAtRow:row column:column] stringValue]);


	/*
	while ([theEvent type] != NSLeftMouseUp)
	{
		int state;
		lastLocation = [self convertPoint:[theEvent locationInWindow]
								 fromView:nil];
		aCell = [self getRow:&row
					  column:&column
					forPoint:lastLocation];
		[self deselectAllCells];
	}
	*/

	[self _mouseDownListMode:theEvent];

}

@end

@implementation CalendarView

- (BOOL) getRow:(int *)row
		 column:(int *)col
		 ofCell:(NSCell *)cell
{
	return [_matrix getRow:row
					column:col
					ofCell:cell];
}

- (int) renderModeOfCell:(NSCell *)cell
{
	int row, col, ren;

	[_matrix getRow:&row
			 column:&col
			 ofCell:cell];

	ren = 0;

	if (col > 0 && col < 6)
	{
		if ([[_matrix cellAtRow:row column:col+1] selectMode])
		{
			ren |= 1;
		}
		if ([[_matrix cellAtRow:row column:col-1] selectMode])
		{
			ren |= 2;
		}
	}
	if (col == 0)
	{
		if ([[_matrix cellAtRow:row column:col+1] selectMode])
		{
			ren |= 1;
		}
	}
	if (col == 6)
	{
		if ([[_matrix cellAtRow:row column:col-1] selectMode])
		{
			ren |= 2;
		}
	}

	return ren;
}

- (void) setFrame:(NSRect)rect
{
	[super setFrame:rect];
	[self _setup_frame];
}

- (void) _setup_frame
{
	NSRect b = [self bounds];
	[_matrix setFrame:NSMakeRect(0,0,NSWidth(b),NSHeight(b)*5/6)];


	[_tdButton setFrame:NSMakeRect(0,1+NSHeight(b)*5/6,NSHeight(b)/6-1,NSHeight(b)/6 - 1)];
	[_monthPop setFrame:NSMakeRect(NSHeight(b)/6-1,1+NSHeight(b)*5/6,NSWidth(b)/2 - (NSHeight(b)/6) + 2,NSHeight(b)/6 - 1)];
	[_yearPop setFrame:NSMakeRect(NSWidth(b)/2 + 1,1+NSHeight(b)*5/6,NSWidth(b)-(NSHeight(b)/3) - (NSWidth(b)/2) - 2,NSHeight(b)/6 - 1)];
	[_lButton setFrame:NSMakeRect(NSWidth(b)-(NSHeight(b)/3),1+NSHeight(b)*5/6,NSHeight(b)/6-1,NSHeight(b)/6 - 1)];
	[_rButton setFrame:NSMakeRect(NSWidth(b)-NSHeight(b)/6,1+NSHeight(b)*5/6,NSHeight(b)/6-1,NSHeight(b)/6 - 1)];
	[self addSubview:_lButton];
}

- (void) matrix:(id)sender
{
	NSLog(@"matrix action");
}

- (void) _setup_matrix
{
	int i,j;
	NSArray *dayColors, *dayStrings;
	dayColors = [NSArray arrayWithObjects:[NSColor redColor],
		[NSColor controlBackgroundColor],
		[NSColor controlBackgroundColor],
		[NSColor controlBackgroundColor],
		[NSColor controlBackgroundColor],
		[NSColor controlBackgroundColor],
		[NSColor controlBackgroundColor],nil];
	dayStrings = [NSArray arrayWithObjects:@"Su",@"Mo",@"Tu",@"We",@"Th",@"Fr",@"Sa",nil];

	for (j = 0; j < 7; j++)
	{
		id cell = [_matrix cellAtRow:0 column:j];
		[cell setTarget:self];
		[cell setAction:@selector(cellAction:)];
		[cell setStringValue:[dayStrings objectAtIndex:j]];
		[cell setColor:[dayColors objectAtIndex:j]];
	}

	for (i = 1; i < 7; i++)
	{
		for (j = 0; j < 7; j++)
		{
			id cell = [_matrix cellAtRow:i column:j];
			[cell setTarget:self];
			[cell setAction:@selector(cellAction:)];
			[cell setColor:[NSColor whiteColor]];
		}
	}

	[_matrix setAction:@selector(matrix:)];
	[_matrix setTarget:self];
}

- (void) _setup_month_pop
{

	[_monthPop addItemWithTitle:@"January"];
	[_monthPop addItemWithTitle:@"February"];
	[_monthPop addItemWithTitle:@"March"];
	[_monthPop addItemWithTitle:@"April"];
	[_monthPop addItemWithTitle:@"May"];
	[_monthPop addItemWithTitle:@"June"];
	[_monthPop addItemWithTitle:@"July"];
	[_monthPop addItemWithTitle:@"Auguest"];
	[_monthPop addItemWithTitle:@"September"];
	[_monthPop addItemWithTitle:@"October"];
	[_monthPop addItemWithTitle:@"November"];
	[_monthPop addItemWithTitle:@"December"];
	

}

- (void) _setup_year_pop
{
	int i;
	[_yearPop removeAllItems];

	for (i = [_viewDate yearOfCommonEra] - YEAR_POPUP_SIZE;
			i < [_viewDate yearOfCommonEra] + YEAR_POPUP_SIZE;
			i++)
	{
		[_yearPop addItemWithTitle:[NSString stringWithFormat:@"%02d", i%100]];
	}
	[_yearPop selectItemAtIndex:YEAR_POPUP_SIZE];
}

- (id) initWithFrame:(NSRect)frame
{
	ASSIGN(_selectStart, [[NSCalendarDate date] dateByAddingYears:0
													 months:0
													   days:-2
													  hours:0
													minutes:0
													seconds:0]);

	ASSIGN(_selectStop, [[NSCalendarDate date] dateByAddingYears:0
													months:0
													  days:+2
													 hours:0
												   minutes:0
												   seconds:0]);


	[super initWithFrame:frame];

	_matrix = [[CalendarMatrix alloc] initWithFrame:NSMakeRect(0,0,NSWidth(frame),NSHeight(frame)*5/6)
										 mode:NSListModeMatrix
									cellClass:[CalendarCell class]
								 numberOfRows:7
							  numberOfColumns:7];
	[self _setup_matrix];
	[self addSubview:_matrix];

	_monthPop = [NSPopUpButton new];
	[self _setup_month_pop];
	[self addSubview:_monthPop];
	[_monthPop setTarget:self];
	[_monthPop setAction:@selector(popMonth:)];

	_yearPop = [NSPopUpButton new];
	[self _setup_year_pop];
	[self addSubview:_yearPop];
	[_yearPop setTarget:self];
	[_yearPop setAction:@selector(popYear:)];

	_lButton = [NSButton new];
	[_lButton setStringValue:@"<"];
	[_lButton setAction:@selector(decMonth:)];
	[_lButton setTarget:self];
	[self addSubview:_lButton];

	_rButton = [NSButton new];
	[_rButton setStringValue:@">"];
	[_rButton setAction:@selector(incMonth:)];
	[_rButton setTarget:self];
	[self addSubview:_rButton];

	_tdButton = [NSButton new];
	[_tdButton setStringValue:@"o"];
	[_tdButton setAction:@selector(today:)];
	[_tdButton setTarget:self];
	[self addSubview:_tdButton];

	[self setCalendarDate:[NSCalendarDate date]];
	[self viewCalendarDate:_date];
	[self _setup_frame];
	return self;
}

- (void) popMonth:(id)sender
{
	[self viewCalendarDate:[NSCalendarDate dateWithYear:[_viewDate yearOfCommonEra]
												  month:[sender indexOfSelectedItem] + 1
													day:1
												   hour:0
												 minute:0
												 second:0
											   timeZone:[_viewDate timeZone]]];
}

- (void) popYear:(id)sender
{
	[self viewCalendarDate:[NSCalendarDate dateWithYear:[_viewDate yearOfCommonEra] - YEAR_POPUP_SIZE + [sender indexOfSelectedItem]
												  month:[_viewDate monthOfYear]
													day:1
												   hour:0
												 minute:0
												 second:0
											   timeZone:[_viewDate timeZone]]];
}

- (void) today:(id)sender
{
	[self viewCalendarDate:_date];
}

- (void) incMonth:(id)sender
{
	int yy, mm;
	yy = [_viewDate yearOfCommonEra];
	mm = [_viewDate monthOfYear]+1;

	if (mm > 12)
	{
		mm -= 12;
		yy++;
	}

	[self viewCalendarDate:[NSCalendarDate dateWithYear:yy
												  month:mm
													day:1
												   hour:0
												 minute:0
												 second:0
											   timeZone:[_viewDate timeZone]]];
}

- (void) decMonth:(id)sender
{
	int yy, mm;
	yy = [_viewDate yearOfCommonEra];
	mm = [_viewDate monthOfYear]-1;

	if (mm < 1)
	{
		mm += 12;
		yy--;
	}

	[self viewCalendarDate:[NSCalendarDate dateWithYear:yy
												  month:mm
													day:1
												   hour:0
												 minute:0
												 second:0
											   timeZone:[_viewDate timeZone]]];
}

- (void) drawRect: (NSRect)r
{
	[super drawRect:r];
}

- (void) dealloc
{
	DESTROY(_date);
	[super dealloc];
}

- (NSCalendarDate *) date
{
	return _date;
}

- (void) setCalendarDate:(NSCalendarDate *)date
{
	ASSIGN(_date,date);
}

- (void) viewCalendarDate:(NSCalendarDate *)date
{
	int i,j,n,nod,dd;

	[_matrix deselectAllCells];
	ASSIGN(_viewDate, date);

	NSLog(@"setting viewdate %@",date);
	[_monthPop selectItemAtIndex:[date monthOfYear]-1];
	[self _setup_year_pop];

	dd = [date dayOfMonth];
	NSCalendarDate *d = [_viewDate dateByAddingYears:0
											  months:0
												days:1-dd
											   hours:0
											 minutes:0
											 seconds:0];

	n = 0 - [d dayOfWeek] + 1;

	d = [d dateByAddingYears:0
					  months:0
						days:31
					   hours:0
					 minutes:0
					 seconds:0];

	nod = 32 - [d dayOfMonth];

	CalendarCell * lastCell = nil;
	for (i = 1; i < 7; i++)
	{
		for (j = 0; j < 7; j++)
		{
			CalendarCell *cell = [_matrix cellAtRow:i column:j];
			[cell setSelectMode:0];
			[cell setStringValue:@""];
			[cell setToday:NO];
			if (n > 0 && n <= nod)
			{
				NSCalendarDate *aDay;
				aDay =
					[NSCalendarDate dateWithYear:[date yearOfCommonEra]
										   month:[date monthOfYear]
											 day:n
											hour:0
										  minute:0
										  second:0
										timeZone:[_viewDate timeZone]];

				if ([_selectStart compare:aDay] == NSOrderedAscending)
				{
					if ([aDay compare:_selectStop] == NSOrderedAscending)
					{
						[cell setSelectMode:1];
					}
				}

				[cell setStringValue:[NSString stringWithFormat:@"%d",n]];
				if (n == [_date dayOfMonth] &&
						[_viewDate monthOfYear] == [_date monthOfYear] &&
						[_viewDate yearOfCommonEra] == [_date yearOfCommonEra])
				{
					[cell setToday:YES];
				}

				lastCell = cell;
			}
			n++;
		}
	}

	[_matrix setNeedsDisplay:YES];
}

- (void) setDelegate:(id)del
{
	ASSIGN(_delegate, del);
}

- (id) delegate
{
	return _delegate;
}

- (void) cellAction:(id)sender
{
	NSCalendarDate *date;
	
	[_delegate setDate: [[_viewDate addTimeInterval:[_viewDate dayOfMonth] * -3600 * 24] addTimeInterval:[sender intValue] * 3600 * 24]];
}
@end
