// ---------------------------------------------------------------------------
// - Aod.hpp                                                                 -
// - aleph object database - command class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_AOD_HPP
#define  ALEPH_AOD_HPP

#ifndef  ALEPH_INTERP_HPP
#include "Interp.hpp"
#endif

#ifndef  ALEPH_COLLECTION_HPP
#include "Collection.hpp"
#endif

namespace aleph {

  /// The Aod class is a derived class from the aleph interpreter that
  /// provide facility to manage the aleph object database. The class 
  /// works with the standard i/o streams and provides a special nameset 
  /// called aod. Such nameset incorporates all commands needed to perform 
  /// data query and management.
  /// @author amaury darsch

  class Aod : public Interp {
  private:
    /// the data collection
    Collection* p_dc;
    /// the current table
    Table* p_tbl;
    /// the aod command nameset
    Nameset* p_cset;

  public:
    /// create a new commander
    Aod (void);

    /// create a stream based commander
    /// @param is the input  stream
    /// @param os the output stream
    /// @param es the error  stream
    Aod (Input* is, Output* os, Output* es);

    /// destroy this commander
    ~Aod (void);

    /// @return the class name
    String repr (void) const;

    /// open a collection by name
    /// @param fname the collection to open
    Collection* open (const String& fname);

    /// save a collection by name
    /// @param fname the file name to write
    void save (const String& fname);

    /// print some collection information
    void info (Output* os) const;

    /// print the collection table  information
    void tinfo (Output* os) const;

    /// create a new table and make it the default
    Table* create (void);

    /// import data into a table by name
    /// @param fname the file name to use
    void import (const String& fname);

    /// select a table by index
    /// @param index the table index
    void select (const long index);

    /// insert elements in the current table
    /// @param elems the elements to insert
    void insert (Vector* elems);

    /// print a table content at in index 
    /// @param os    the output stream
    /// @param max   the maximum number of rows
    /// @param start the start index
    /// @param flag  the string or literal flag
    void tblrpt (Output* os, long max, long start, bool flag) const;

  private:
    // make the copy constructor private
    Aod (const Aod&);
    // make the assignment operator private
    Aod& operator = (const Aod&);
  };
}

#endif
