// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "virtuseraddrfilter.h"
#include <iostream>
#include <fstream>

//#define DEBUG

virtuserAddrFilter::virtuserAddrFilter() :
		strPrefix( "virtuser" ),
		strName( "Virtual User Addressfilter" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Convert addresses with a virtusertable." )
{
	addParam( "file", "Set a Filename and acivate this Filter.", "Path and Filename.", STRING, "" );
}

virtuserAddrFilter::~virtuserAddrFilter()
{}

bool virtuserAddrFilter::init( void )
{
	//char buffer[1024];
	std::string filename = getStringParam( "file" );
	std::string token, translation;
	if ( filename != "" )
	{
		std::ifstream vf( filename.c_str() );
		if ( vf )
		{
#ifdef DEBUG
			std::cerr << "DEBUG: Open file \"" << filename << "\" for reading..." << std::endl;
#endif
			while ( !vf.eof() )
			{
				vf >> token; // Read one token.
				if ( ( token[ 0 ] == '#' ) || ( token.size() == 0 ) )
				{
					vf.ignore( 1024, '\n' ); // read up to a linefeed or 1024 chars.
				}
				else
				{
					vf >> translation;
					mapVirtUser[ token ] = translation;
#ifdef DEBUG
					std::cerr << "DEBUG: \"" << token << "\"=>\"" << translation << "\"" << std::endl;
#endif

				}
			}
			if ( mapVirtUser.size() > 0 )
			{
				enabled = true;
#ifdef DEBUG
				std::cerr << "DEBUG: Dump of the generated map." << std::endl;
				std::map< std::string, std::string >::iterator i;
				long lc = 0;
				for ( i = mapVirtUser.begin(); i != mapVirtUser.end(); i++ )
				{
					std::cerr << "DEBUG: " << lc++ << " " << i->first << " >> " << i->second << std::endl;
				}
#endif

			}
			else
			{
				enabled = false; // no lines.
			}
		}
		else
		{
			std::cerr << "Can't find/open virtusertable file \"" << filename << "\"." << std::endl;
			return false; // Stop anteater.
		}
	}
	else
	{
		enabled = false;
	}
	return true;
}

bool virtuserAddrFilter::checkAddr( std::string &addr )
{
	bool changed = false;
	if ( !enabled ) return false;
	if ( addr.find( "@" ) == std::string::npos ) return false; // Skip local addresses.
	if ( ( addr[ 0 ] == '<' ) && ( addr.size() > 1 ) )  // erase <> around the email address...
	{
		changed = true;
		addr.erase( 0, 1 );
		addr.erase( addr.size() - 1, 1 );
	}
	if ( mapVirtUser.find( addr ) != mapVirtUser.end() )  // Check 100% hit
	{
#ifdef DEBUG
		std::cerr << "DEBUG: Translating " << addr << " to " << mapVirtUser[ addr ] << "." << std::endl;
#endif
		addr = mapVirtUser[ addr ]; // Translate a "full" hit.
		return true;
	}
	if ( mapVirtUser.find( addr.substr( addr.find( "@" ) ) ) != mapVirtUser.end() )  // Check for Domain...
	{
#ifdef DEBUG
		std::string debugDomain = addr.substr( addr.find( "@" ) );
		std::cerr << "DEBUG: Translating " << debugDomain << " to "
		<< mapVirtUser[ debugDomain ] << "." << std::endl;
#endif
		addr = mapVirtUser[ addr.substr( addr.find( "@" ) ) ]; // Translate a "domain" hit.
		return true;
	}
	return changed; // no hit
}

//
// End
//


