/*
 *	snmp.c from Access Point SNMP Utils for Linux
 *	basic snmp packets assembly/disassembly and send/receive functions
 *
 * Copyright (c) Roman Festchook <roma at polesye dot net>
 *               Jan Rafaj <jr-aputils at cedric dot unob dot cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "ap-utils.h"

#define RETRIES 5

sigjmp_buf position;

extern char *community;
extern short ap_type;
extern int sockfd;
extern struct in_addr ap_ip;
int retries;
char *buf = NULL;

static void alarm_handler()
{
    retries--;
    siglongjmp(position, 1);
}

/*
unsigned int ber_decode_uint(unsigned char *bevp, int len)
{
    unsigned int out = 0;

    while (len--) {
	out = (out << 7) | (*bevp & (*bevp & 0x80 ? 0x7f : 0xff));
	bevp++;
    }

    return out;
}
*/

int ber(char *message, varbind * varbindlist, int num, int type)
{

    char pdu1[1024], pdu[1024], *list = pdu1;
    int len_var = 0, lenp, len_tmp, len = 0, community_len =
	strlen(community), i;
    char snmp_ver[] = { 0x02, 0x01, 0x00 };
    const char req_id[] = { 0x02, 0x01 }, err[] = {
    0x02, 0x01, 0x00};

    for (i = 0; i < num; i++) {
	*(pdu1 + len++) = ASN_HEADER;
	len_tmp =
	    (varbindlist + i)->len_oid + (varbindlist + i)->len_val + 4;
	if (!(ap_type == NWN && type == SET)) {
	    *(pdu1 + len++) = 0x82;
	    *(pdu1 + len++) = (len_tmp - (len_tmp % 256)) / 256;
	}
	*(pdu1 + len++) = len_tmp % 256;
	*(pdu1 + len++) = OID_VALUE;
	*(pdu1 + len++) = (varbindlist + i)->len_oid;
	memcpy(pdu1 + len, (varbindlist + i)->oid,
	       (varbindlist + i)->len_oid);
	len += (varbindlist + i)->len_oid;
	*(pdu1 + len++) = (varbindlist + i)->type;
	*(pdu1 + len++) = (varbindlist + i)->len_val;
	memcpy(pdu1 + len, (varbindlist + i)->value,
	       (varbindlist + i)->len_val);
	len += (varbindlist + i)->len_val;
    }

    len_var = len;

    lenp = 0;
    len_tmp = len_var + ((ap_type == NWN && type == SET) ? 11 : 13);
    *(pdu + lenp++) = type;
    if (!(ap_type == NWN && type == SET)) {
	*(pdu + lenp++) = 0x82;
	*(pdu + lenp++) = (len_tmp - (len_tmp % 256)) / 256;
    }
    *(pdu + lenp++) = len_tmp % 256;

    memcpy(pdu + lenp, req_id, sizeof(req_id));
    lenp += sizeof(req_id);
    *(pdu + lenp++) =
	(1 + (int) (255.0 * rand() / (RAND_MAX + 1.0))) & 0xFF;
    memcpy(pdu + lenp, err, sizeof(err));
    lenp += sizeof(err);
    memcpy(pdu + lenp, err, sizeof(err));
    lenp += sizeof(err);
    *(pdu + lenp++) = ASN_HEADER;
    len_tmp = len_var;
    if (!(ap_type == NWN && type == SET)) {
	*(pdu + lenp++) = 0x82;
	*(pdu + lenp++) = (len_tmp - (len_tmp % 256)) / 256;
    }
    *(pdu + lenp++) = len_tmp % 256;
    memcpy(pdu + lenp, list, len_var);
    lenp += len_var;

    *message = ASN_HEADER;
    len = 1;

    i = lenp + community_len + 5;
    if (!(ap_type == NWN && type == SET)) {
	*(message + len++) = 0x82;
	*(message + len++) = (i - (i % 256)) / 256;
    }
    *(message + len++) = i % 256;

    memcpy(message + len, snmp_ver, 3);
    len += 3;
    *(message + len++) = STRING_VALUE;
    *(message + len++) = community_len & 0xFF;
    memcpy(message + len, community, community_len);
    len += community_len;
    memcpy(message + len, pdu, lenp);
    len += lenp;

    return len;
}

int snmp(varbind * varbindlist, int num, int type)
{
    unsigned char message[1024], *start;
    unsigned int num_reply;
    int len;
    struct sockaddr_in server;

    if (num == 0)
	return 1;

    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(161);
    server.sin_addr.s_addr = ap_ip.s_addr;

    signal(SIGALRM, alarm_handler);
    retries = RETRIES;
    sigsetjmp(position, 1);
    if (!retries) {
	return 0;
    }

    alarm(1);
    len = ber(message, varbindlist, num, type);
    if (sendto(sockfd, message, len, 0, (struct sockaddr *) &server, SIZE)
	== -1) {
	alarm(0);
	return 0;
    }
    if ((len = recv(sockfd, message, 1024, 0)) == -1) {
	alarm(0);
	return 0;
    }
    alarm(0);

    if (buf)
	free(buf);
    buf = (char *) malloc(len);
    memcpy(buf, message, len);

    start = buf;
    num_reply = 0;
    if (*start != ASN_HEADER) {
	return 0;
    }

    if (start[1] & 0x80) {
	start += (start[1] & 0x7F) + 2;
	len -= ((start[1] & 0x7F) + 2);
    } else {
	start += 2;
	len -= 2;
    }

    len -= *(start + 4) + 5;
    start += *(start + 4) + 5;

    if (*(start) != RESPONSE) {
	return 0;
    }



    if (start[1] & 0x80) {
	start += (start[1] & 0x7F) + 2;
	len -= ((start[1] & 0x7F) + 2);
    } else {
	start += 2;
	len -= 2;
    }

    if (*(start + 5))
	return -*(start + 8);

    start += 9;
    len -= 9;
    if (*(start) != ASN_HEADER) {
	return 0;
    }


    if (start[1] & 0x80) {
	start += (start[1] & 0x7F) + 2;
	len -= ((start[1] & 0x7F) + 2);
    } else {
	start += 2;
	len -= 2;
    }
    while (len) {
	if (*(start) != ASN_HEADER) {
	    return num_reply;
	}
	if (start[1] & 0x80) {
	    start += (start[1] & 0x7F) + 2;
	    len -= ((start[1] & 0x7F) + 2);
	} else {
	    start += 2;
	    len -= 2;
	}


	varbindlist[num_reply].len_oid = start[1];
/*	if(varbindlist[num_reply].oid)
	    free(varbindlist[num_reply].oid);
	varbindlist[num_reply].oid =
	    (char *) malloc(varbindlist[num_reply].len_oid);
	memcpy(varbindlist[num_reply].oid, start + 2,
	       varbindlist[num_reply].len_oid);
*/
	varbindlist[num_reply].oid = start + 2;
	len -= *(start + 1) + 2;
	start += *(start + 1) + 2;
	varbindlist[num_reply].type = *(start);

	if (start[1] & 0x80) {
	    varbindlist[num_reply].len_val = start[2];
	    start += (start[1] & 0x7F) + 2;
	    len -= ((start[1] & 0x7F) + 2);
	} else {
	    varbindlist[num_reply].len_val = start[1];
	    start += 2;
	    len -= 2;
	}

/*	if(varbindlist[num_reply].value)
	    free(varbindlist[num_reply].value);
	varbindlist[num_reply].value =
	    (char *) malloc(varbindlist[num_reply].len_val);
	memcpy(varbindlist[num_reply].value, start,
	       varbindlist[num_reply].len_val);
*/
	varbindlist[num_reply].value = start;
	len -= varbindlist[num_reply].len_val;
	start += varbindlist[num_reply].len_val;
	num_reply++;
    }

    return num_reply;
}
