/***************************************************************************
 $RCSfile: accadd.cpp,v $
                             -------------------
    cvs         : $Id: accadd.cpp,v 1.7 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Mon Jan 28 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <openhbci.h>
#include "accadd.h"



HBCI::Error accAdd(HBCI::Pointer<AQMAPI> hbciif,
		   HBCI::SimpleConfig &opt){
    int country;
    string instid;
    string userid;
    string accnr;
    HBCI::Error err;
    HBCI::Pointer<HBCI::Account> acc;
    HBCI::Pointer<HBCI::Bank> bank;
    HBCI::Pointer<HBCI::User> cust;
    list<HBCI::Pointer<HBCI::Customer> >::const_iterator culit;
    bool isauth;

    country=opt.getIntVariable("country",280,opt.root());
    instid=opt.getVariable("instid","",opt.root());
    userid=opt.getVariable("user","",opt.root());
    accnr=opt.getVariable("accnr","",opt.root());

    try {
        cust=hbciif.ref().findUser(country,instid,userid);
        if (!cust.isValid())
            return HBCI::Error("accAdd()",
                             ERROR_LEVEL_NORMAL,
                             0,
                             ERROR_ADVISE_DONTKNOW,
                             "user not found.");

        bank=cust.ref().bank();
        acc=bank.ref().findAccount(accnr);
        if (acc.isValid())
            return HBCI::Error("accAdd()",
                             ERROR_LEVEL_NORMAL,
                             0,
                             ERROR_ADVISE_DONTKNOW,
                             "account already exists.");
	acc=hbciif.ref().accountFactory(bank,accnr);
	bank.ref().addAccount(acc);

	// check whether we are already authorized to this account
	if (!(cust.ref().customers().empty())) {
	  isauth=false;
	  for (culit=cust.ref().customers().begin();
	       culit!=cust.ref().customers().end();
	       culit++) {
	    if (acc.ref().isAuthorized(*culit)) {
	      isauth=true;
	      break;
	    }
	  } // for
	  if (!isauth) {
	    // add authorized customer, if any
	    acc.ref().addAuthorizedCustomer(cust.ref().customers().front());
	  } // if !isauth
	} // if there are customers
    } // try
    catch (HBCI::Error lerr) {
      err=lerr;
    } // catch

    return err;
}


