/***************************************************************************
 $RCSfile: createcustomer.cpp,v $
                             -------------------
    cvs         : $Id: createcustomer.cpp,v 1.6 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Sat Jan 26 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "createcustomer.h"


HBCI::Error createCustomer(HBCI::Pointer<AQMAPI> hbciif,
			   HBCI::SimpleConfig &opt){
    int country;
    string userid;
    string customerid;
    string role;
    string instid;
    string mediumname;
    string server;
    string tmp;
    HBCI::Pointer<HBCI::Bank> bank;
    HBCI::Pointer<HBCI::User> user;
    HBCI::Pointer<HBCI::Customer> cust;
    HBCI::Pointer<HBCI::Medium> medium;
    HBCI::Error err;

    user.setDescription("createUser::user (HBCI::User)");

    // get some variables
    country=opt.getIntVariable("country",280,opt.root());
    instid=opt.getVariable("instid","",opt.root());
    userid=opt.getVariable("user","",opt.root());
    customerid=opt.getVariable("customer","",opt.root());
    role=opt.getVariable("role","",opt.root());

    // find user
    user=hbciif.ref().findUser(country,
                               instid,
                               userid);
    if (!user.isValid())
        return HBCI::Error("createcustomer()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "user not found.");

    // create customer, if given
    if (!customerid.empty()) {
        cust=hbciif.ref().customerFactory(user,
                                          customerid,
                                          role);
        user.ref().addCustomer(cust);
    }

    return HBCI::Error();
}



