#!/bin/sh

if [ "x$CC" = "x" ] ; then
    export CC=gcc
fi

pwd=`pwd`

base_libs="sigc++ pbd soundtouch midi++ ardour"
gui_libs="gtkmm gtkmmext gtk-canvas"
gui_progs="gtk_ardour"
nogui_progs="ksi_ardour"

prog_dirs="$gui_progs $nogui_progs"
lib_dirs="$base_libs $gui_libs"
xtra_path=
libs_to_process=

while [ $# -gt 0 ]
do

    case $1 in

    -gui*) prog_dirs="$nogui_progs"
           lib_dirs="$base_libs"
	   ;;

    -ksi*) prog_dirs="$gui_progs"
           lib_dirs="$base_libs $gui_libs"
           ;;

    -path=*)
           xtra_path=$xtra_path`expr "x$1" : 'x-path=\(.*\)'`:
           ;;

    *)    libs_to_process="$libs_to_process $1"
          ;;
    esac
    shift

done

PATH=$xtra_path$PATH
export PATH

acmacrodir=$pwd/aclocal
system_macrodir=`aclocal --print-ac-dir`	

acargs=
pkgpath=
auto_lib_dirs=

echo "
----------------------------------------------------------------------
Checking basic compilation tools ...
"

for tool in pkg-config autoconf aclocal automake libtool gettext autopoint
do
    if which $tool >/dev/null 2>&1 ; then
	echo "	$tool: found."
    else
	echo "\
You do not have $tool correctly installed. You cannot build Ardour
without this tool."
	exit 1
    fi
done

# check the version of autoconf, because it matters a LOT
# and while i'm here: what the f*ck? we now have to
# write our own configuration tests to see if the configuration
# test system is adequate? gag....
#
# Correct. time for #ifdef AUTO_ME_HARDER ... ?
#

autoconf --version | perl -e '
while(<>) { 
    @x=split(/[ \t\n]+/,$_); 
    $version=$x[3]; $v =~ s/[a-z]+$//; 
    if($version >= 2.52){
        exit 0;
    }else{
        print "\n\tversion $version of autoconf found: ardour requires 2.52 or above.\n";
        exit 1;
    }
}
'      

if [ $? != 0 ] ; then
    exit 1
fi

# Check version of automake.  Equally frustrating as checking 
# the version for autoconf.

automake --version | perl -e '
while(<>) { 
    @x=split(/[ \t\n]+/,$_); 
    $version=$x[3]; $v =~ s/[a-z]+$//; 
    if($version >= 1.7){
        exit 0;
    }else{
        print "\n\tversion $version of automake found: ardour requires 1.7 or above.\n";
        exit 1;
    }
}
'      

if [ $? != 0 ] ; then
    exit 1
fi

echo "
----------------------------------------------------------------------
linking autoconf macros to $acmacrodir ... 
"

for x in $lib_dirs ; do

	pkgpath="${pkgpath}$pwd/libs/$x:"

	# catch any autoconf m4 files that we'll need
	# need to have access to during the autogen step

	macros=`echo $pwd/libs/$x/*.m4`

	if [ x"$macros" != "x$pwd/libs/$x/*.m4" ] ; then
	        for m4 in $macros  
		do
		   bm4=`basename $m4`

		   if [ -f $system_macrodir/$bm4 ] ; then
		      echo "\
----------------------------------------------------------------------

You already have a version of $bm4 installed in $system_macrodir.
This isn't going to work, because aclocal is too stupid to use
an ordered search path. I'm therefore going to ignore the
one in this tree, and rely on the installed one. If this
results in errors, you will have deinstall the library that 
$bm4 is associated with.

If you don't like this policy, I suggest that you write to the
authors of aclocal and suggest that they improve their
program.

----------------------------------------------------------------------
"
		       continue
		   fi

		   if [ $bm4 != aclocal.m4 ] && [ $bm4 != acinclude.m4 ] ; then
			m4copy="$m4copy $m4"
		   fi	       
		done
        fi

	# damn!

	if [ $x = "midi++" ] ; then 
	    libname=midipp
        else 
	    libname=$x
	fi

	auto_lib_dirs="$auto_lib_dirs libs/$x"
done

if [ ! -d $acmacrodir ] ; then 
    mkdir $acmacrodir ; 
else
    rm -rf $acmacrodir/*.m4
fi

for m4 in $m4copy ; do
   ln -s $m4 $acmacrodir
done

export ACLOCAL_FLAGS="$ACLOCAL_FLAGS -I $acmacrodir"

cat > $acmacrodir/optflags.m4 <<EOF
AC_DEFUN([AM_OPT_FLAGS],[
dnl
dnl figure out how best to optimize
dnl 

gcc_major_version=`$CC -dumpversion | sed -e 's/\..*//'`

if test "\$target_cpu" = "powerpc"; then
  AC_DEFINE(POWERPC, 1, "Are we running a ppc CPU?")
  altivecLinux=`cat /proc/cpuinfo | grep -i altivec >/dev/null`
  if test "\$?" = "0"; then
    AC_DEFINE(HAVE_ALTIVEC_LINUX, 1, "Is there Altivec Support ?")
    if test "\$gcc_major_version" = "3"; then
dnl -mcpu=7450 does not reliably work with gcc 3.*
      OPT_FLAGS="-D_REENTRANT -O2 -mcpu=7400 -maltivec -mabi=altivec"
    else
      OPT_FLAGS="-D_REENTRANT -O3 -mcpu=7400"
    fi
  else
    OPT_FLAGS="-D_REENTRANT -O3 -mcpu=750 -mmultiple"
  fi
  OPT_FLAGS="\$OPT_FLAGS -mhard-float -mpowerpc-gfxopt"
elif echo \$target_cpu | grep "i*86" >/dev/null; then
  cat /proc/cpuinfo | grep mmx >/dev/null
  if test \$? = 0; then
    mmx="-mmmx"
  fi
  cat /proc/cpuinfo | grep sse >/dev/null
  if test \$? = 0; then
    sse="-msse -mfpmath=sse"
  fi
  cat /proc/cpuinfo | grep 3dnow >/dev/null
  if test \$? = 0; then
    dreidnow="-m3dnow"
  fi
  AC_DEFINE(x86, 1, "Nope its intel")
  if test "\$target_cpu" = "i586"; then
    OPT_FLAGS="-DREENTRANT -O3 -march=i586 -fomit-frame-pointer -ffast-math -fstrength-reduce -fmove-all-movables"
  elif test "\$target_cpu" = "i686"; then
    OPT_FLAGS="-D_REENTRANT -O3 -march=i686 -fomit-frame-pointer -ffast-math -fstrength-reduce -fmove-all-movables"
    if test "\$gcc_major_version" = "3"; then
      OPT_FLAGS="\$OPT_FLAGS \$mmx \$sse \$dreidnow"
    fi
  else
    OPT_FLAGS="-D_REENTRANT -O3 -fomit-frame-pointer -ffast-math -fstrength-reduce -fmove-all-movables"
  fi
fi

OPT_FLAGS="\$OPT_FLAGS -pipe"

# LARGEFILE_FLAGS="\`getconf LFS_CFLAGS\`"
LARGEFILE_FLAGS="-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE"

CXXFLAGS="-g -D_REENTRANT \$LARGEFILE_FLAGS"
if test x"\$GXX" = xyes ; then
   CXXFLAGS="\$CXXFLAGS -Wall"
fi
if test x"\$GXX" = xyes ; then
   OPT_CXXFLAGS="\$OPT_FLAGS -Wall \$LARGEFILE_FLAGS"
fi

PROF_FLAGS="-pg"

dnl 
dnl some link flags to try to speed linking
dnl

CXXFLAGS="\$CXXFLAGS -fno-merge-constants"

])
EOF

# rip the version out of configure.ac

release_text=`head -1 configure.ac | sed 's/.[^,]*, \([-._0-9a-zA-Z][-._0-9a-zA-Z]*\))/\1/'`
echo "rtext = " $release_text

cat > $acmacrodir/buildenv.m4 <<EOF

AC_DEFUN([AM_BUILD_ENVIRONMENT],[
top_marker=top_marker
depth=0
while test x\$ARDOUR_TOP = x -a \$depth -lt 255 ; do
    if test -f \$top_marker ; then
        ARDOUR_TOP=\`dirname \$top_marker\`
    else 
        top_marker=../\$top_marker
    fi
    depth=\`expr \$depth + 1\`
done

if test \$depth -eq 255 ; then
   AC_MSG_ERROR([ the top of the Ardour source tree was not found.])
fi

dnl
dnl convert to absolute path
dnl 

ARDOUR_TOP=\`cd \$ARDOUR_TOP; pwd\`

export LIBDIRS="$lib_dirs"

ACLOCAL_FLAGS="-I \$ARDOUR_TOP/aclocal"
ACLOCAL_AMFLAGS="-I \$ARDOUR_TOP/aclocal \`if test -d m4 ; then echo -I m4; fi\`"
AC_SUBST(ACLOCAL_FLAGS)
AC_SUBST(ACLOCAL_AMFLAGS)

LATEST_RELEASE_VERSION="$release_text"
AC_SUBST(LATEST_RELEASE_VERSION)

BASE_LIBS="\$ARDOUR_TOP/libs/midi++/libmidipp.a \$ARDOUR_TOP/libs/pbd/libpbd.a \$ARDOUR_TOP/libs/sigc++/sigc++/libsigc.a"
BASE_INCLUDES="-I\$ARDOUR_TOP/libs/sigc++ -I\$ARDOUR_TOP/libs/sigc++/sigc++/config -I\$ARDOUR_TOP/libs/pbd -I\$ARDOUR_TOP/libs/midi++ -I\$ARDOUR_TOP/libs/ardour -I\$ARDOUR_TIP/libs/soundtouch"
GUI_LIBS="\$ARDOUR_TOP/libs/gtkmmext/libgtkmmext.a \$ARDOUR_TOP/libs/midi++/libmidipp.a \$ARDOUR_TOP/libs/gtk-canvas/libgtk-canvas.a \$ARDOUR_TOP/libs/gtkmm/src/gtk--/libgtkmm.a \$ARDOUR_TOP/libs/gtkmm/gdk--/gdk--/libgdkmm.a"
GUI_INCLUDES="-I\$ARDOUR_TOP/libs/ -I\$ARDOUR_TOP/libs/gtk-canvas -I\$ARDOUR_TOP/libs/gtk-canvas/gtk-canvas -I\$ARDOUR_TOP/libs/gtkmmext -I\$ARDOUR_TOP/libs/gtkmm/gdk-- -I\$ARDOUR_TOP/libs/gtkmm/src -I\$ARDOUR_TOP/libs/gtkmm"
CFLAGS="\$CFLAGS -I\$ARDOUR_TOP/libs/sigc++ -I\$ARDOUR_TOP/libs/sigc++/sigc++/config -I\$ARDOUR_TOP/libs/pbd -I\$ARDOUR_TOP/libs/midi++ -I\$ARDOUR_TOP/libs/ardour -I\$ARDOUR_TOP/libs/soundtouch"
CXXFLAGS="\$CXXFLAGS -I\$ARDOUR_TOP/libs/sigc++ -I\$ARDOUR_TOP/libs/sigc++/sigc++/config -I\$ARDOUR_TOP/libs/pbd -I\$ARDOUR_TOP/libs/midi++ -I\$ARDOUR_TOP/libs/ardour -I\$ARDOUR_TOP/libs/soundtouch"
LIBS="\$LIBS \$ARDOUR_TOP/libs/soundtouch/libsoundtouch.a \$ARDOUR_TOP/libs/midi++/libmidipp.a \$ARDOUR_TOP/libs/pbd/libpbd.a \$ARDOUR_TOP/libs/sigc++/sigc++/libsigc.a"
])
EOF

echo "
----------------------------------------------------------------------
Bootstrapping makefiles etc.

Ignore any warnings about AC_TRY_RUN, AC_PROG_LEX, and AC_DEFINE ...
"

if [ "$libs_to_process" = "" ] ; then
    libs_to_process="libs $auto_lib_dirs $prog_dirs"
fi

for d in $libs_to_process
do
    (cd $d && echo "Building autoconf files for $d ..." && sh ./autogen.sh) || exit 1
done

echo "Building autoconf/automake files for the top level ..."
aclocal $ACLOCAL_FLAGS && automake --foreign --add-missing && autoconf

echo "


----------------------------------------------------------------------
Bootstrapping is complete. 

You can now run:

    ./configure
    make
    make install

If you're not a member of ardour-dev yet, please join. See 
http://ardour.org/ for details.
"


exit 0

