/*
    Copyright (C) 2003 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: named_selection.h,v 1.4 2004/11/29 03:04:45 pauld Exp $
*/

#ifndef __ardour_named_selection_h__
#define __ardour_named_selection_h__

#include <string>
#include <list>

#include <ardour/stateful.h>

class XMLNode;

namespace ARDOUR
{
class Session;
class Playlist;

struct NamedSelection : public Stateful
{
    NamedSelection (std::string, std::list<Playlist*>&);
    NamedSelection (Session&, const XMLNode&);
    virtual ~NamedSelection ();

    std::string name;
    std::list<Playlist*> playlists;

    XMLNode& get_state (void);

    int set_state (const XMLNode&);

    static SigC::Signal1<void,NamedSelection*> NamedSelectionCreated;
};

}/* namespace ARDOUR */

#endif /* __ardour_named_selection_h__ */

