#!/bin/sh

# Ark - Libraries, Tools & Programs for MMORPG developpements.
# Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
# Please see the file "AUTHORS" for a list of contributors
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


# Get a boolean answer
get_boolean_answer()
{
	PROMPT_LINE="$1 [Y/N] : ";

	while true;
	do
		echo "${PROMPT_LINE}"
		read -r ANSWER;

		if [ "${ANSWER}" = "Y" -o "${ANSWER}" = "y" ]; then
			return 1;
		elif [ "${ANSWER}" = "N" -o "${ANSWER}" = "n" ]; then
			return 0;
		fi
	done
}

check_directory()
{
	if [ -e "$1" -a ! -d "$1" ]; then
		echo "$1 exists but it is not a directory"

		if ! get_boolean_answer "Rename it to $1.bak ?"; then
			mv $1 $1.bak
			mkdir $1
		else
			exit 1
		fi
	elif [ -e "$1" ]; then
		echo "Ark's configuration files have already been created";

		if get_boolean_answer "Overwrite old configuration ?"; then
			exit 1;
		fi
	else
		mkdir $1
	fi
}

if [ ! -e configure.in ]; then
	echo "This script has to be run from the Ark source directory (the one where you can find 
 configure.in, etc.)"
	exit 1 
fi

check_directory "${HOME}/.arkhart";

cfg_file=${HOME}/.arkhart/arkfactories.cfg
game_dir=$PWD

cat >${cfg_file} << EOF
factoryList::AddSearchDir("${game_dir}/Modules/Lua");
factoryList::AddSearchDir("${game_dir}/Modules/HeightField");
factoryList::AddSearchDir("${game_dir}/Modules/Renderer");
factoryList::AddSearchDir("${game_dir}/Modules/Collision");
factoryList::AddSearchDir("${game_dir}/Engine");

ark::Script::Lua::Lib = "libArkLua";
ark::Collision::Opcode::Lib = "libArkCollision";
ark::World::HeightField::Lib = "libArkHeightField";
ark::Renderer::OpenGL::Lib = "libArkRenderer";
ark::Updater::Engine::Lib = "libArkEngine";
EOF

# Print some informations
echo "Written ${cfg_file} .. :";
echo "  Ark directory is \"${game_dir}\"";

