/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __MAINWND_H__
#define __MAINWND_H__

#include <kmainwindow.h>

/*==================================*/
/*	DEFINES
 *==================================*/

enum {
	DOCUMENT_AUDIO = 0,
	DOCUMENT_VCD,
	DOCUMENT_DATA,
	DOCUMENT_RIPPER,
	_DOCUMENT_MAX
};

/*========================================================*/
/*	Main window class definition
 *========================================================*/

class ArsonDocWidget;
class QTabWidget;
class KURL;

class ArsonFrame : public KMainWindow
{
	Q_OBJECT

public:
	ArsonFrame (const char *name = NULL);
	virtual ~ArsonFrame (void);

	ArsonDocWidget *findDocument (const QString &doctype);
	ArsonDocWidget *setCurrentDocument (int index);
	ArsonDocWidget *currentDocument (void) { return m_pCurrentDoc; }

	static const QString &documentTitle (int doc);
	
	KActionCollection *docActions (void) { return m_pDocActions; }

	static ArsonFrame *getFrame (void) { return spMainFrame; }

private slots:
	void slotDebug (void);
	void slotConfig (void);
	void slotOpen (void);
	void slotWriteImg (void);
	void slotReadCd (void);
	void slotCopyCd (void);
	void slotWriteDir (void);
	void slotOpenRecent (const KURL &url);
	void slotTabSelChange (QWidget *pCurrent);
	void slotToggleVisibility (void);
	void slotConfigToolbars (void);
	void slotConfigKeys (void);
	void slotUnlock (void);
	void slotBlank (void);
	void slotImport (void);
	void slotFixate (void);
	
private:
	virtual void closeEvent (QCloseEvent *close);

	void addView (const QString &name, QWidget *pWidget);
	void setupActions (void);
	void createDocuments (void);

	QTabWidget *m_pTabCtrl;				//	The tab control
	KActionCollection *m_pDocActions;	//	Actions associated with documents
	ArsonDocWidget *m_pages[_DOCUMENT_MAX];
	ArsonDocWidget *m_pCurrentDoc;

	static ArsonFrame *spMainFrame;
};

/*========================================================*/
#endif	/*	__MAINWND_H__	*/
