// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#ifndef ATLAS_OBJECTS_ENTITY_ROOTENTITY_H
#define ATLAS_OBJECTS_ENTITY_ROOTENTITY_H

#include <Atlas/Objects/Root.h>


namespace Atlas { namespace Objects { namespace Entity { 

/** Starting point for entity hierarchy

Later in hierarchy tree objtype changes to 'object' when actual game objects are made.

*/
class RootEntity : public Root
{
  public:
    /// Construct a RootEntity instance.
    RootEntity();
  protected:
    /// Constructor for sub-classes.
    RootEntity(const char *,const char *);
  public:
    /// Default destructor.
    virtual ~RootEntity();

    /// Create a new class for RootEntity.
    static RootEntity Class();

    /// Check whether the attribute "name" exists.
    virtual bool hasAttr(const std::string& name)const;
    /// Retrieve the attribute "name". Throws NoSuchAttrException if it does
    /// not exist.
    virtual Atlas::Message::Element getAttr(const std::string& name)
            const throw (NoSuchAttrException);
    /// Set the attribute "name" to the value given by"attr"
    virtual void setAttr(const std::string& name,
                         const Atlas::Message::Element& attr);
    /// Remove the attribute "name". This will not work for static attributes.
    virtual void removeAttr(const std::string& name);

    /// Send the contents of this object to a Bridge.
    virtual void sendContents(Atlas::Bridge* b) const;

    /// Convert this object to a Message::Element.
    virtual Atlas::Message::Element asObject() const;

    /// Convert this object to a Message::Element::MapType.
    virtual Atlas::Message::Element::MapType asMap() const;

    /// Set the "loc" attribute.
    inline void setLoc(const std::string& val);
    /// Set the "pos" attribute.
    inline void setPos(const Atlas::Message::Element::ListType& val);
    /// Set the "velocity" attribute.
    inline void setVelocity(const Atlas::Message::Element::ListType& val);
    /// Set the "contains" attribute.
    inline void setContains(const Atlas::Message::Element::ListType& val);
    /// Set the "stamp_contains" attribute.
    inline void setStampContains(double val);

    /// Retrieve the "loc" attribute.
    inline const std::string& getLoc() const;
    /// Retrieve the "loc" attribute as a non-const reference.
    inline std::string& getLoc();
    /// Retrieve the "pos" attribute.
    inline const Atlas::Message::Element::ListType& getPos() const;
    /// Retrieve the "pos" attribute as a non-const reference.
    inline Atlas::Message::Element::ListType& getPos();
    /// Retrieve the "velocity" attribute.
    inline const Atlas::Message::Element::ListType& getVelocity() const;
    /// Retrieve the "velocity" attribute as a non-const reference.
    inline Atlas::Message::Element::ListType& getVelocity();
    /// Retrieve the "contains" attribute.
    inline const Atlas::Message::Element::ListType& getContains() const;
    /// Retrieve the "contains" attribute as a non-const reference.
    inline Atlas::Message::Element::ListType& getContains();
    /// Retrieve the "stamp_contains" attribute.
    inline double getStampContains() const;
    /// Retrieve the "stamp_contains" attribute as a non-const reference.
    inline double& getStampContains();

protected:
    std::string attr_loc;
    Atlas::Message::Element::ListType attr_pos;
    Atlas::Message::Element::ListType attr_velocity;
    Atlas::Message::Element::ListType attr_contains;
    double attr_stamp_contains;

    inline void sendLoc(Atlas::Bridge*) const;
    inline void sendPos(Atlas::Bridge*) const;
    inline void sendVelocity(Atlas::Bridge*) const;
    inline void sendContains(Atlas::Bridge*) const;
    inline void sendStampContains(Atlas::Bridge*) const;

};

//
// Inlined member functions follow.
//

void RootEntity::setLoc(const std::string& val)
{
    attr_loc = val;
}

void RootEntity::setPos(const Atlas::Message::Element::ListType& val)
{
    attr_pos = val;
}

void RootEntity::setVelocity(const Atlas::Message::Element::ListType& val)
{
    attr_velocity = val;
}

void RootEntity::setContains(const Atlas::Message::Element::ListType& val)
{
    attr_contains = val;
}

void RootEntity::setStampContains(double val)
{
    attr_stamp_contains = val;
}

const std::string& RootEntity::getLoc() const
{
    return attr_loc;
}

std::string& RootEntity::getLoc()
{
    return attr_loc;
}

const Atlas::Message::Element::ListType& RootEntity::getPos() const
{
    return attr_pos;
}

Atlas::Message::Element::ListType& RootEntity::getPos()
{
    return attr_pos;
}

const Atlas::Message::Element::ListType& RootEntity::getVelocity() const
{
    return attr_velocity;
}

Atlas::Message::Element::ListType& RootEntity::getVelocity()
{
    return attr_velocity;
}

const Atlas::Message::Element::ListType& RootEntity::getContains() const
{
    return attr_contains;
}

Atlas::Message::Element::ListType& RootEntity::getContains()
{
    return attr_contains;
}

double RootEntity::getStampContains() const
{
    return attr_stamp_contains;
}

double& RootEntity::getStampContains()
{
    return attr_stamp_contains;
}


} } } // namespace Atlas::Objects::Entity

#endif // ATLAS_OBJECTS_ENTITY_ROOTENTITY_H
