# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::triggers::delete;
use base 'AXP::Command::triggers';

use Arch::Util qw(remove_dir);

sub optusage {
	"[options] limit"
}

sub infoline {
	"delete a trigger from the watch list"
}

sub options {
	(
	)
}

sub helptext {
	q{
		This command deletes the previously added trigger completely.
		The argument should be either a trigger limit, or the trigger
		number as shown by 'list'.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $name = shift @ARGV;
	my $trigger = $self->load_trigger($name);

	remove_dir($trigger->{dir});

	print "* trigger for $trigger->{name} is deleted\n";
}

1;
