/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BASKETPROPERTIESWIDGET_H
#define BASKETPROPERTIESWIDGET_H

#include <qwidget.h>
#include <kdialogbase.h>

class QLineEdit;
class QCheckBox;
class QComboBox;
class KColorButton;
class KIconButton;
class QVButtonGroup;
class KIntNumInput;

class Basket;

/** The widget that hold main basket settings.
  * @author Sbastien Laot
  */
class BasketPropertiesWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesWidget();
  public slots:
	void saveChanges();
  protected slots:
	void emptyIcon();
  private:
	Basket       *m_basket;
	QLineEdit    *m_name;
	KIconButton  *m_icon;
	KColorButton *m_color;
	KColorButton *m_altColor;
	QComboBox    *m_hAlign;
	QComboBox    *m_vAlign;
	QCheckBox    *m_showCheckBoxes;
};

/** The widget that allow to edit basket add item policy settings.
  * @author Sbastien Laot
  */
class BasketPropertiesAddItemWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesAddItemWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesAddItemWidget();
  public slots:
	void saveChanges();
  private slots:
	void insertSideSelected(int index);
  signals:
	void insertSideChanged(bool onTop);
  private:
	Basket     *m_basket;
	QComboBox  *m_insertAtEnd;
	QCheckBox  *m_insertAtCursorPos;
	QCheckBox **m_ViewFileContent;
};

/** The widget that hold basket stack settings.
  * @author Sbastien Laot
  */
class BasketPropertiesStackWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesStackWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesStackWidget();
  public slots:
	void saveChanges();
	void insertSideChanged(bool onTop);
  private:
	Basket        *m_basket;
	QWidget       *m_stackOptions;
	QCheckBox     *m_isAStack;
	QVButtonGroup *m_takeOnSameSide;
	QVButtonGroup *m_afterDrag;
};

/** The widget that hold basket clipboard manager settings.
  * @author Sbastien Laot
  */
class BasketPropertiesClipboardWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesClipboardWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesClipboardWidget();
  public slots:
	void saveChanges();
  private:
	Basket        *m_basket;
	KIntNumInput  *m_maxItems;
	QVButtonGroup *m_which;
};

/** The widget that hold basket mirror settings.
  * @author Sbastien Laot
  */
class BasketPropertiesMirrorWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesMirrorWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesMirrorWidget();
  public slots:
	void saveChanges();
  private:
	Basket    *m_basket;
	QCheckBox *m_onlyNewFiles;
};

/** The widget that hold basket onClic default settings.
  * @author Sbastien Laot
  */
class BasketPropertiesOnClicWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesOnClicWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesOnClicWidget();
  public slots:
	void saveChanges();

  private:
	Basket        *m_basket;
	QVButtonGroup *m_contentOnClickAction; // TODO: ClickActionWidget
	QVButtonGroup *m_fileOnClickAction;    // TODO: ClickActionWidget
};

/** The dialog that hold basket settings.
  * @author Sbastien Laot
  */
class BasketPropertiesDialog : public KDialogBase
{
  Q_OBJECT
  public:
	BasketPropertiesDialog(Basket *basket, QWidget *parent = 0);
	~BasketPropertiesDialog();
  protected slots:
	void slotApply();
	void slotOk();
  private:
	Basket                          *m_basket;
	BasketPropertiesWidget          *m_properties;
	BasketPropertiesAddItemWidget   *m_addPolicy;
	BasketPropertiesOnClicWidget    *m_onClic;
	BasketPropertiesStackWidget     *m_stack;
	BasketPropertiesClipboardWidget *m_clipboard;
	BasketPropertiesMirrorWidget    *m_mirror;
};

#endif // BASKETPROPERTIESWIDGET_H
