#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple add tests
# Copyright © 2004 Canonical Ltd
#             Author: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "add"

setup_add () {
  tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
  cd hello-world
}  

begin_test "add single random id"
setup_add
echo "a file" > new-file.c
tla add new-file.c
id=$(< .arch-ids/new-file.c.id)
end_test 

begin_test "add single random id with id chosen"
setup_add
echo "a file" > new-file.c
tla add -i foobar new-file.c
id=$(< .arch-ids/new-file.c.id)
[ "foobar" = $id  ]
end_test 


begin_test "adding multiple files with an explicit id fails"
setup_add
echo "a file" > new-file.c
echo "another file" > new-file2.c
tla add -i bad_boy new-file.c new-file2.c && test_fail "no error reported"
if [ -e  .arch-ids/new-file.c.id ]; then 
 test_fail "id created"
fi 
if [ -e .arch-ids/new-file.c.id ]; then
 test_fail "id for file 2 created"
fi
end_test 

begin_test "add an id for a directory works"
setup_add
mkdir newdir
tla add newdir
id=$(< newdir/.arch-ids/\=id)
end_test 

begin_test "add a chosen id for a directory works"
setup_add
mkdir newdir
tla add -i super_duper newdir
id=$(< newdir/.arch-ids/\=id)
[ "super_duper" = $id  ]
end_test 

begin_test "add an id for a nonexistent path fails"
setup_add
tla add newpath && test_fail "no error reported"
if [ -e .arch-ids/newpath.id ]; then
 test_fail "id created"
fi
if [ -e newpath/.arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for a symlink to a nonexistent path works"
setup_add
ln -s missingpath newpath
tla add newpath || test_fail "failed to add newpath"
if [ ! -e .arch-ids/newpath.id ]; then
 test_fail "id file not created"
fi
end_test 

begin_test "add an id for {arch} fails"
setup_add
tla add \{arch\} && test_fail "no error reported"
if [ -e .arch-ids/\{arch\}.id ]; then
 test_fail "id created"
fi
if [ -e \{arch\}/.arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for a dir in {arch} fails"
setup_add
mkdir \{arch\}/foo
tla add \{arch\}/foo && test_fail "no error reported"
if [ -e \{arch\}/.arch-ids/foo.id ]; then
 test_fail "id created"
fi
if [ -e \{arch\}/foo/.arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for a dir in {arch} from inside {arch} fails"
setup_add
mkdir \{arch\}/foo
cd \{arch\}
tla add foo && test_fail "no error reported"
if [ -e .arch-ids/foo.id ]; then
 test_fail "id created"
fi
if [ -e foo/.arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for ../{arch} from inside {arch} fails"
setup_add
cd \{arch\}
tla add ../\{arch\} && test_fail "no error reported"
if [ -e .arch-ids/..id ]; then
 test_fail "id created"
fi
if [ -e .arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for . from inside {arch} fails"
setup_add
cd \{arch\}
tla add . && test_fail "no error reported"
if [ -e .arch-ids/..id ]; then
 test_fail "id created"
fi
if [ -e .arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for .arch-ids fails"
setup_add
tla add .arch-ids && test_fail "no error reported"
if [ -e .arch-ids/.arch-ids.id ]; then
 test_fail "id created"
fi
if [ -e .arch-ids/.arch-ids/\=id ]; then
 test_fail "id created"
fi
end_test 

begin_test "add an id for an id file fails"
setup_add
echo "Demo" > sample
tla add sample
tla add .arch-ids/sample.id && test_fail "no error reported"
if [ -e .arch-ids/.arch-ids/sample.id.id ]; then
 test_fail "id created"
fi
if [ -e .arch-ids/sample.id/\=id ]; then
 test_fail "id created"
fi
end_test 


clean_workdir
