/*

   BlackBook - GTK+ Address Book
   Copyright (C) 2000 Felipe Bergo

   Author: Felipe Bergo (bergo@seul.org)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "blackbook.h"

#include "book20.xpm"
#include "book48.xpm"
#include "book64.xpm"
#include "strips.xpm"

int BlackBook::Id=0;

BlackBook::BlackBook() : Window("BlackBook") {
  HandleBox *handle;
  Toolbar *tbar;
  VBox *vb;

  Id=getId();
  allowSave=1;

  setDefaultSize(400,400);
  setPosition(GTK_WIN_POS_CENTER);
  realize();
  setIcon(book48_xpm);
  
  vb=new VBox(FALSE,0);
  add(vb);

  tabs=new Notebook();
  vb->packStart(tabs,TRUE,TRUE,6);

  handle=new HandleBox();

  tbar=new Toolbar(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);

  tbar->appendSpace();
  tbar->append(new Pixmap(SmallIcon::NewTab),"New tab","New tab");
  tbar->append(new Pixmap(SmallIcon::KillTab),"Kill tab","Kill tab");
  tbar->appendSpace();
  tbar->append(new Pixmap(SmallIcon::New),"New entry","New entry");
  tbar->append(new Pixmap(SmallIcon::Kill),"Remove entry","Remove entry");
  tbar->appendSpace();
  /*
  tbar->append(new Pixmap(SmallIcon::Find),"Search","Search");
  tbar->appendSpace();
  */

  tbar->append(new Pixmap(book20_xpm),"About","About");
  tbar->setBorderWidth(6);

  vb->Gap=0;
  handle->add(tbar);
  vb->packEnd(handle);

  tbar->forward(this);
  toolbarId=tbar->getId();

  tlist=new list<BookTab *>;

  load();

  if (tlist->size()==0) {
    tlist->push_back(new BookTab("People"));
    tabs->append( (*(tlist->begin())),
		  (*(tlist->begin()))->tabwidget );
  }

  show();
}

void BlackBook::clicked(int bar,int tool) {
  int j,k;
  list<BookTab *>::iterator pos;
  MessageBox *mb;
  
  if (bar==toolbarId) {
    switch(tool) {
    case 0:
      tlist->push_back(new BookTab("More People"));
      tabs->append( (*(--(tlist->end()))),
		    (*(--(tlist->end())))->tabwidget );
      save();
      break;
    case 1:
      mb=new MessageBox("Are you sure you want to remove this tab\n"\
			"and all of its entries ?",
			"Confirmation",
			MessageIcon::Question,
			MsgYes|MsgNo);
      if (mb->Result!=MsgYes)
	return;

      j=tabs->getPage();
      if ((j<0)||(tlist->size()==0))
	break;
      k=j;
      for(pos=tlist->begin();k;k--)
	pos++;
      tlist->erase(pos);
      tabs->remove(j);
      save();
      break;
    case 2:
      getCurTab()->addEntry();
      break;
    case 3:
      getCurTab()->removeEntry();
      break;
    case 4:
      new AboutDialog();
      break;
    }
  }
}

void BlackBook::destroyed() {
  Gtk::MainQuit();
}

BookTab * BlackBook::getCurTab() {
  list<BookTab *>::iterator pos;
  int j;

  j=tabs->getPage();
  for(pos=tlist->begin();j;j--)
    pos++;
  return(*pos);
}

void BlackBook::receiveMessage(char *msg) {
  save();
}

void BlackBook::load() {
  FILE *f;
  char *p,loc[512];
  char buf[256];
  int i,n;
  BookTab *tmptab;

  p=getenv("HOME");
  sprintf(loc,"%s/.blackbook",p);

  f=fopen(loc,"r");
  if (!f)
    return;

  allowSave=0;
  fgets(buf,255,f);
  p=strtok(buf,"\n");
  n=atoi(p);

  for(i=0;i<n;i++) {
    tlist->push_back( tmptab = new BookTab(f) );
    tabs->append( (*(--(tlist->end()))),
		  (*(--(tlist->end())))->tabwidget );
    tmptab->update();
  }

  fclose(f);
  allowSave=1;
}

void BlackBook::save() {
  FILE *f;
  char *p,loc[512];
  list<BookTab *>::iterator pos;

  if (!allowSave)
    return;
  
  p=getenv("HOME");
  sprintf(loc,"%s/.blackbook",p);

  f=fopen(loc,"w");
  if (!f)
    return;

  fprintf(f,"%d\n",tlist->size());
  for(pos=tlist->begin();pos!=tlist->end();pos++)
    (*pos)->save(f);

  fclose(f);
  chmod(loc,0600);
}

int main(int argc,char **argv) {
  Gtk::Init(&argc,&argv);
  new BlackBook();
  Gtk::Main();
  return 0;
}

/// BookTab

BookTab::BookTab(char *title) : Notebook() {
  int i,j;
  char c,d[5];
  ScrolledWindow *sw[15];

  strcpy(Title,title);
  setBorderWidth(6);

  tabwidget=new HBox(FALSE,2);
  tabwidget->Gap=3;

  tablabel=new Label(Title);
  tabrename=new Button();
  tabrename->add(new Pixmap(strips_xpm));

  idRename=tabrename->getId();
  idOk=idCancel=-1;

  tabwidget->packStart(tabrename);
  tabwidget->packStart(tablabel);

  setTabPos(GTK_POS_LEFT);
  tabrename->forward(this);

  for(i=0;i<15;i++) {
    sw[i]=new ScrolledWindow();
    sw[i]->setPolicy(GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
    data[i]=new CList(4);
    data[i]->setShadowType(GTK_SHADOW_IN);
    data[i]->setSelectionMode(GTK_SELECTION_SINGLE);
    data[i]->setColumnTitle(0,"Name");
    data[i]->setColumnTitle(1,"Phone");
    data[i]->setColumnTitle(2,"Email");
    data[i]->setColumnTitle(3,"ObjId");
    data[i]->columnTitlesShow();
    data[i]->setColumnVisibility(3,FALSE);
    idList[i]=data[i]->getId();
    listSel[i]=-1;
    data[i]->forward(this);
    for(j=0;j<3;j++)
      data[i]->setColumnAutoResize(j,TRUE);
    sw[i]->add(data[i]);
  }

  append(sw[0],new Label("All"));
  
  strcpy(d,"AZ");
  for(c='A',i=1;c<='Z';c+=2,i++) {
    d[0]=c;
    d[1]=c+1;
    append(sw[i],new Label(d));
  }

  append(sw[14],new Label("Other"));

  entries=new list<BookEntry *>;
}

BookTab::BookTab(FILE *f) : Notebook() {
  int i,j;
  char c,d[5];
  char number[256],*n,content;
  ScrolledWindow *sw[15];

  setBorderWidth(6);

  fgets(number,255,f);
  n=strtok(number,"\n");
  content=atoi(n);

  fgets(number,255,f);
  strcpy(Title,strtok(number,"\n"));

  tabwidget=new HBox(FALSE,2);
  tabwidget->Gap=3;

  tablabel=new Label(Title);
  tabrename=new Button();
  tabrename->add(new Pixmap(strips_xpm));

  idRename=tabrename->getId();
  idOk=idCancel=-1;

  tabwidget->packStart(tabrename);
  tabwidget->packStart(tablabel);

  setTabPos(GTK_POS_LEFT);
  tabrename->forward(this);

  for(i=0;i<15;i++) {
    sw[i]=new ScrolledWindow();
    sw[i]->setPolicy(GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
    data[i]=new CList(4);
    data[i]->setShadowType(GTK_SHADOW_IN);
    data[i]->setSelectionMode(GTK_SELECTION_SINGLE);
    data[i]->setColumnTitle(0,"Name");
    data[i]->setColumnTitle(1,"Phone");
    data[i]->setColumnTitle(2,"Email");
    data[i]->setColumnTitle(3,"ObjId");
    data[i]->columnTitlesShow();
    data[i]->setColumnVisibility(3,FALSE);
    idList[i]=data[i]->getId();
    listSel[i]=-1;
    data[i]->forward(this);
    for(j=0;j<3;j++)
      data[i]->setColumnAutoResize(j,TRUE);
    sw[i]->add(data[i]);
  }

  append(sw[0],new Label("All"));
  
  strcpy(d,"AZ");
  for(c='A',i=1;c<='Z';c+=2,i++) {
    d[0]=c;
    d[1]=c+1;
    append(sw[i],new Label(d));
  }

  append(sw[14],new Label("Other"));

  entries=new list<BookEntry *>;

  for(i=0;i<content;i++) {
    entries->push_back(new BookEntry(this->getId(),f));
    update();
  }
}

void BookTab::clicked(int id) {

  if (id==idRename) {
    popRename();
  }

  if (id==idOk) {
    strcpy(Title,nameEntry->getText());
    tablabel->setText(Title);
    sendMessage(BlackBook::Id,"save");
  }

  if ((id==idCancel)||(id==idOk)) {
    if (renameDlg) {
      renameDlg->grabRemove();
      renameDlg->destroy();
    }
  }
}

void BookTab::destroyed(int id) {
  if (id==getId())
    return;
  if (id==renameDlg->getId()) {
    delete renameDlg;
    renameDlg=NULL;
  }
}

void BookTab::rowSelected(int id,int row,int column,GdkEventButton *geb) {
  int i;
  for(i=0;i<15;i++)
    if (id==idList[i])
      listSel[i]=row;

  if (geb!=NULL) {
    if (geb->type==GDK_2BUTTON_PRESS) {
      list<BookEntry *>::iterator pos;
      int s=row;
      for(pos=entries->begin();s;s--)
	pos++;
      (*pos)->edit();
    }
  }
}

void BookTab::rowUnselected(int id,int row,int column,GdkEventButton *geb) {
  int i;
  for(i=0;i<15;i++)
    if (id==idList[i])
      listSel[i]=-1;
}

void BookTab::popRename() {
  VBox *v;
  HBox *h,*b;
  Button *ok,*can;

  renameDlg=new Window(GTK_WINDOW_DIALOG,"Rename Tab");
  renameDlg->setPosition(GTK_WIN_POS_CENTER);
  renameDlg->setBorderWidth(2);

  v=new VBox(FALSE,2);
  
  renameDlg->add(v);

  v->Gap=4;
  v->packStart(h=new HBox(FALSE,2));
  h->packStart(new Label("Tab name:"));
  
  v->packStart(nameEntry=new Entry());
  nameEntry->setText(Title);
  v->packStart(new HSeparator());
  v->packStart(b=new HBox(TRUE,6));
  b->packStart(new Label(" "));
  b->packStart(new Label(" "));

  b->packStart(ok=new Button(" Ok "));
  b->packStart(can=new Button(" Cancel "));

  ok->forward(this);
  can->forward(this);

  idOk=ok->getId();
  idCancel=can->getId();

  renameDlg->show();
  nameEntry->grabFocus();
  renameDlg->grabAdd();
}

void BookTab::addEntry() {
  BookEntry *be;
  entries->push_back(be=new BookEntry(getId()));
  be->edit();
}

void BookTab::removeEntry() {
  int i,j;
  char *zz;
  list<BookEntry *>::iterator pos;
  MessageBox *mb;
  char tt[256];

  j=getPage();
  if (listSel[j]==-1)
    return;
  data[j]->getText(listSel[j],3,&zz);
  i=atoi(zz);

  for(pos=entries->begin();pos!=entries->end();pos++)
    if ( (*pos)->getId() == i ) {
      sprintf(tt,"Remove %s's entry ?",
	      (*pos)->Name);
      mb=new MessageBox(tt,
			"Confirmation",
			MessageIcon::Question,
			MsgYes|MsgNo);
      if (mb->Result!=MsgYes)
	return;
      entries->erase(pos);
      update();
      break;
    }
}

void BookTab::save(FILE *f) {
  list<BookEntry *>::iterator pos;
  fprintf(f,"%d\n%s\n",entries->size(),Title);
  for(pos=entries->begin();pos!=entries->end();pos++) {
    (*pos)->save(f);
  }
}

void BookTab::update() {
  list<BookEntry *>::iterator pos;
  list<char *> row;
  int i;
  char c,z[32];

  for(pos=entries->begin();pos!=entries->end();pos++)
    if ( (*pos)->isNull() ) {
      entries->erase(pos);
      pos=entries->begin();
    }

  for(i=0;i<15;i++) {
    data[i]->freeze();
    data[i]->clear();
    listSel[i]=-1;
  }
  
  entries->sort(EntryComparator());

  for(pos=entries->begin();pos!=entries->end();pos++) {
    row.erase(row.begin(),row.end());
    row.push_back( (*pos)->Name );
    row.push_back( (*pos)->Phone );
    row.push_back( (*pos)->Email );
    sprintf(z,"%d", (*pos)->getId() );
    row.push_back( z );

    data[0]->append(row);
    c=(*pos)->tabHash();
    if ((c>='A')&&(c<='Z')) {
      data[1+(c-'A')/2]->append(row);
    } else
      data[14]->append(row);
  }

  for(i=0;i<15;i++) {
    data[i]->thaw();
  }

  sendMessage(BlackBook::Id,"save");
}

void BookTab::receiveMessage(char *msg) {
  update();
}

/**** Entry ****/

BookEntry::BookEntry(int updateId) {
  Name[0]=0;
  Phone[0]=0;
  Fax[0]=0;
  Email[0]=0;
  Memo[0]=0;
  upId=updateId;
}

BookEntry::BookEntry(int updateId,FILE *f) {
  char reserved[4096];

  fread(Name,1,7,f);

  // only 000001/2 exists for now
  fread(Name, 1,256, f);
  fread(Phone,1,64,  f);
  fread(Fax,  1,64,  f);
  fread(Email,1,256, f);
  fread(Memo, 1,1024,f);
  fread(reserved,1,4096,f);
  
  upId=updateId;
}

void BookEntry::save(FILE *f) {
  char reserved[4096];
  
  fwrite(VERSIONSTRING, 1, 7, f);
  fwrite(Name, 1,256, f);
  fwrite(Phone,1,64,  f);
  fwrite(Fax,  1,64,  f);
  fwrite(Email,1,256, f);
  fwrite(Memo, 1,1024,f);
  memset(reserved,0,4096);
  fwrite(reserved,1,4096,f);
}

char BookEntry::tabHash() {
  char *p,c;
  char temp[256];

  strcpy(temp,Name);
  c=0;
  p=strtok(temp," \t");
  if (p)
    c=p[0];
  while(p=strtok(NULL," \t"))
    c=p[0];
  return toupper(c);
}

void BookEntry::edit() {
  VBox *v;
  Label *l[5];
  HBox *h[5],*b;
  Button *ok,*can;
  int i;

  editDlg=new Window(GTK_WINDOW_DIALOG,"BlackBook Entry");
  editDlg->setDefaultSize(300,300);
  editDlg->setPosition(GTK_WIN_POS_CENTER);
  editDlg->setBorderWidth(2);

  v=new VBox(FALSE,2);
  editDlg->add(v);

  l[0]=new Label("Name");
  l[1]=new Label("Phone");
  l[2]=new Label("Fax");
  l[3]=new Label("Email");
  l[4]=new Label("Notes");
  
  for(i=0;i<5;i++) {
    h[i]=new HBox(FALSE,2);
    h[i]->packStart(l[i]);
  }

  for(i=0;i<4;i++) {
    v->packStart(h[i]);
    v->packStart(es[i]=new Entry());
  }
  v->packStart(h[4]);
  v->packStart(ts=new Text());

  v->Gap=4;
  v->packStart(new HSeparator());

  b=new HBox(TRUE,6);
  b->packStart(new Label(" "));
  b->packStart(new Label(" "));
  b->packStart(new Label(" "));

  b->packStart(ok=new Button(" Ok "));
  b->packStart(can=new Button(" Cancel "));

  v->packStart(b);
  
  ok->forward(this);
  can->forward(this);
  idOk=ok->getId();
  idCancel=can->getId();
  
  es[0]->setText(Name);
  es[1]->setText(Phone);
  es[2]->setText(Fax);
  es[3]->setText(Email);
  ts->setEditable(TRUE);
  ts->insert(Memo);

  editDlg->show();
  es[0]->grabFocus();
  editDlg->grabAdd();
}

void BookEntry::clicked(int id) {
  if (id==idOk) {
    strcpy(Name,es[0]->getText());
    strcpy(Phone,es[1]->getText());
    strcpy(Fax,es[2]->getText());
    strcpy(Email,es[3]->getText());
    strcpy(Memo,ts->getChars(0,-1));
    sendMessage(upId,"update");
  }

  if ((id==idOk)||(id==idCancel)) { 
    sendMessage(upId,"update");
    editDlg->grabRemove();
    editDlg->destroy();
  }

}

void BookEntry::destroyed(int id) {
  if (id==getId())
    return;
  if (id==editDlg->getId()) {
    delete editDlg;
    editDlg=NULL;
  }
}
 
int BookEntry::isNull() {
  return(!strlen(Name));
}

int EntryComparator::operator()(BookEntry *e1, BookEntry *e2) const {
  char c1,c2,*p;
  int l1,l2,ml,i;

  l1=strlen(e1->Name);
  l2=strlen(e2->Name);
  ml=l1; if (l2<ml) ml=l2;

  for(i=0;i<ml;i++) {
    c1=toupper(i[strtok(p=strdup(e1->Name)," \t\n")]);
    free(p);
    c2=toupper(i[strtok(p=strdup(e2->Name)," \t\n")]);
    free(p);
    if (c1==c2)
      continue;
    return(c1<c2);
  }
  return 0;
}

AboutDialog::AboutDialog() : Window(GTK_WINDOW_DIALOG,"About BlackBook") {
  HBox *mb,*hb;
  VBox *v1,*v2;
  char about[1024];
  Button *dis;
  Label *l;

  setPosition(GTK_WIN_POS_CENTER);
  setBorderWidth(6);
  realize();
  mb=new HBox(FALSE,4);
  
  add(mb);

  v1=new VBox(FALSE,1);
  v2=new VBox(FALSE,1);

  mb->packStart(v1);
  mb->packStart(v2);

  v1->packStart(new Pixmap(book64_xpm));

  sprintf(about,"BlackBook version %d\n",VERSION);
  strcat(about,"(C) 2000 Felipe Bergo\n");
  strcat(about,"bergo@seul.org\n\n");
  strcat(about,"BlackBook comes with ABSOLUTELY NO WARRANTY;\n");
  strcat(about,"This is free software, and you are welcome to\n");
  strcat(about,"redistribute it under the conditions expressed in\n");
  strcat(about,"the GNU General Public License, version 2 or later.\n");
  strcat(about,"Visit http://www.gnu.org for further information.\n");

  v2->packStart(l=new Label(about));
  l->setJustify(GTK_JUSTIFY_LEFT);

  v2->packEnd(hb=new HBox(FALSE,4));
  v2->packEnd(new HSeparator(),FALSE,FALSE,5);

  hb->packEnd(dis=new Button(" Dismiss "));
  dis->forward(this);
  grabAdd();
  show();
}

void AboutDialog::clicked(int id) {
  grabRemove();
  delete this;
}
