#ifndef _ADDELEMENT_CPP_
#define _ADDELEMENT_CPP_

#include <iostream.h>

#include "addElement.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "song.h"
extern Song * sonG;

AddElement::AddElement(Element * e, Compound * list) : Operation(), _element(e), _list(list) {
  _type = ADDELEMENT;
  _description = "add element";
  _to_be_undone = true;
  if (list) {
    list->add(e);
  }
  _delete = 0;
}

AddElement::AddElement(const AddElement& el) : Operation(el)
{
  _type = ADDELEMENT;
  _element = el._element;
  _list = el._list;
  _delete = el._delete;
}

AddElement::~AddElement() {
  if (_delete!=0) delete _delete;
}

void AddElement::undo() {
  if (_list) {
    _element->hide();
    _list->remove(_element);
    _delete = _element;
  }
}

void AddElement::redo() {
  if (_list) {
    _list->add(_element);
    _element->show();
    _delete = 0;
  }
}



// ---------------
// virtuals:
//

ostream & AddElement::print(int dep, ostream & s) const {
  s << spc(dep) << "<ADDELEMENT element=\"" << _element->ctype() << "\" compound=\"" << _list->ctype() << "\" />" << endl;
  return s;
}

void AddElement::flush(const char * c) const {
  cout << c << "ADDELEMENT" << endl;
}

Element * AddElement::copy() const {
  return new AddElement(*this);
}




#endif
