#ifndef _ADDORNAMENT_CPP_
#define _ADDORNAMENT_CPP_

#include <iostream.h>

#include "addOrnament.h"
#include "ornament.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "note.h"

extern Song * sonG;

AddOrnament::AddOrnament(Ornament * o, Note * note) : Operation(), _ornament(o), _note(note) {
  _type = ADDORNAMENT;
  _description = "add ornament";
  _to_be_undone = true;
  if (note) {
    note->add(o);
  }
  _delete = 0;
}

AddOrnament::AddOrnament(const AddOrnament& o) : Operation(o)
{
  _type = ADDORNAMENT;
  _ornament = o._ornament;
  _note = o._note;
  _delete = o._delete;
}

AddOrnament::~AddOrnament() {
  if (_delete!=0) delete _delete;
}

void AddOrnament::undo() {
  if (_note) {
    _note->remove(_ornament);
    _delete = _ornament;
  }
}

void AddOrnament::redo() {
  if (_note) {
    _note->add(_ornament);
    _delete = 0;
  }
}



// ---------------
// virtuals:
//

ostream & AddOrnament::print(int dep, ostream & s) const {
  s << spc(dep) << "<ADDORNAMENT ornament=\"" << _ornament->ctype() << "\" compound=\"" << _note->ctype() << "\" />" << endl;
  return s;
}

void AddOrnament::flush(const char * c) const {
  cout << c << "ADDORNAMENT" << endl;
}

Element * AddOrnament::copy() const {
  return new AddOrnament(*this);
}




#endif
