#ifndef _ADDSYMBOL_CPP_
#define _ADDSYMBOL_CPP_

#include <iostream.h>

#include "addSymbol.h"
#include "symbol.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "part.h"

extern Song * sonG;

AddSymbol::AddSymbol(Symbol * o, Part * part) : Operation(), _symbol(o), _part(part) {
  _type = ADDSYMBOL;
  _description = "add symbol";
  _to_be_undone = true;
  if (part) {
    part->add(o);
  }
  _delete = 0;
}

AddSymbol::AddSymbol(const AddSymbol& o) : Operation(o)
{
  _type = ADDSYMBOL;
  _symbol = o._symbol;
  _part = o._part;
  _delete = o._delete;
}

AddSymbol::~AddSymbol() {
  delete _delete;
}

void AddSymbol::undo() {
  if (_part) {
    _part->remove(_symbol);
    _delete = _symbol;
  }
}

void AddSymbol::redo() {
  if (_part) {
    _part->add(_symbol);
    _delete = 0;
  }
}



// ---------------
// virtuals:
//

ostream & AddSymbol::print(int dep, ostream & s) const {
  s << spc(dep) << "<ADDSYMBOL symbol=\"" << _symbol->ctype() << "\" compound=\"" << _part->ctype() << "\" />" << endl;
  return s;
}

void AddSymbol::flush(const char * c) const {
  cout << c << "ADDSYMBOL" << endl;
}

Element * AddSymbol::copy() const {
  return new AddSymbol(*this);
}




#endif
