#ifndef _ALSAMANAGER_H_
#define _ALSAMANAGER_H_

#include "config.h"

#ifdef HAVE_ALSA

#include "alsaSeqlib.h"

class AlsaManager
{
 private:
  int _timebase;
  int _tempo;
  int _delay;
  int _devnum;
  const char ** _devlist;
  seq_context_t * ctxp; // preliminary, should be opened and closed via singleton...
  snd_seq_queue_status_t status;
  long _offset;

  void initDeviceList();
  
  void test();

 public:
  AlsaManager();
  ~AlsaManager();
  int devnum();
  const char * device(int);
  void hit(int out, int ch, int pitch, int vol);
  void playStart(long off);
  void playNote(int out, int channel, int pitch, int vol, long pos, long len);
  void playEnd();
  void prgchange(long pos, int channel, int prg);
  long ticks();
  double time();
  void tempo(int tempo);
  int tempo();
  void event(int,int,int,int,long);
};

#endif

#endif
