#ifndef _GLUENOTE_CPP_
#define _GLUENOTE_CPP_

#include <iostream.h>

#include "glueNote.h"
#include "element.h"
#include "compound.h"
#include "reference.h"

#include "event.h"
#include "part.h"
#include "track.h"
#include "song.h"
#include "note.h"

extern Song * sonG;
extern Table * selectioN;

GlueNote::GlueNote(Note * nt, Part * pt) : _part(pt), _note(nt), _delete(0) {
  _type = GLUENOTE;
  _description = "glue note";
  _to_be_undone = true;
  if (_note) {
    _next = (Note*) _part->next(_note);
    if (_next) {
      _len = _note->duration();
      long sum =  _len + _next->duration();
      _note->setDuration(sum);
      _part->remove(_next);
      _delete = _next;
    }
  }
}

GlueNote::GlueNote(const GlueNote& el) : Operation(el) {
  _type = GLUENOTE;
  _note = el._note;
  _part = el._part;
  _next = el._next;
  _len  = el._len;
  _delete = el._delete;
}

GlueNote::~GlueNote() {
    delete _delete;
}

void GlueNote::undo() {
  if (_note) {
    _part->insertAfter(_next,_note);
    _note->setDuration(_len);
    _delete = 0;
  }
}

void GlueNote::redo() {
  if (_note) {
    _next = (Note*) _part->next(_note);
    if (_next) {
      _len = _note->duration();
      long sum =  _len + _next->duration();
      _note->setDuration(sum);
      _part->remove(_next);
      _delete = _next;
    }
  }
}



// ---------------
// virtuals:
//

ostream & GlueNote::print(int dep, ostream & s) const {
  s << spc(dep) << "<GLUENOTE note=\"" << _note << "\" _part=\"" << _part << "\" />" << endl;
  return s;
}

void GlueNote::flush(const char * c) const {
  cout << c << "GLUENOTE" << endl;
}

Element * GlueNote::copy() const {
  return new GlueNote(*this);
}




#endif
