#ifndef _GLUEPARTS_CPP_
#define _GLUEPARTS_CPP_

#include <iostream.h>

#include "glueParts.h"
#include "element.h"
#include "compound.h"

#include "event.h"
#include "part.h"
#include "track.h"
#include "song.h"
extern Song * sonG;

GlueParts::GlueParts(Part * pt) : _part(pt), _lost(0) {
  _type = GLUEPARTS;
  _description = "glue parts";
  _to_be_undone = true;
  if (_part) {
    Part * pt2 = (Part*) _part->next(_part);
    if (pt2!=0 && pt2->ghostOf()==0) {
      _relpos = pt2->start()-_part->start();
      _lost = _part->partGlue();
      _lost->hide();
    }
  }
}

GlueParts::GlueParts(const GlueParts& el) : Operation(el) {
  _type = GLUEPARTS;
  _part = el._part;
  _relpos = el._relpos;
  _lost = el._lost;
}

GlueParts::~GlueParts() {
  delete _lost;
}

void GlueParts::undo() {
  Event * newstart = _part->partSplit(_relpos);
  if (newstart!=0) {
    // Part * _newpart = new Part(_part->track());
    Position offset = _part->start(newstart);
    _lost->setStart(offset);
    _lost->show();
    for (Event * ev = newstart; ev != 0; ev = (Event*) _lost->next(ev))
      ev->setInternalStart(ev->internalStart() - offset);
    _lost->setContent(newstart);
    _part->track()->add(_lost);
  }
  _lost = 0;
}

void GlueParts::redo() {
  if (_part) {
    Part * pt2 = (Part*) _part->next(_part);
    if (pt2!=0) {
      _relpos = pt2->start()-_part->start();
      _lost = _part->partGlue();
      _lost->hide();
    }
  }
}



// ---------------
// virtuals:
//

ostream & GlueParts::print(int dep, ostream & s) const {
  s << spc(dep) << "<GLUEPARTS part=\"" << _part << "\" relpos=\"" << _relpos << "\" />" << endl;
  return s;
}

void GlueParts::flush(const char * c) const {
  cout << c << "GLUEPARTS" << endl;
}

Element * GlueParts::copy() const {
  return new GlueParts(*this);
}




#endif
