#ifndef _MUPPRINTER_H_
#define _MUPPRINTER_H_

#include "scorePrinter.h"
#include "prScorePainter.h"
#include "position.h"

#include <ostream.h>

class PrScoreEditor;

class MupPrinter : public ScorePrinter, public PrScorePainter
{
 private:
  ostream * _out;
  void specifyAtts(int attr, ostream * outp);
  int _system_counter;
  int _lyrics_systems; // piano system excluded!
  int tupbas; // tuplet base
  int tupdur; // tuplet duration
  double tupcoef; // tuplet coefficient to calculate the displayed length from the duration
  int cli; // length

 public:
  MupPrinter();
  virtual void print(PrScoreEditor * ed, const char * fname, bool pp, bool pps);
  virtual void paintBar(ScoreBar*, PrScoreEditor*, Table*, int, int, int);
  virtual void paintGroup(ScoreGroup*, PrScoreEditor*, Table*, int, int);
  virtual void paintChord(ScoreChord*, PrScoreEditor*, Table*, int, int);
  virtual void paintBreak(ScoreBreak*, PrScoreEditor*, int, int);
  virtual int indentSystem(ScoreBar*);

  class MupLyrics
    {
      int cli;
      int dot;
      MupLyrics * next;
      char * lyrics;
      char * help;
      
    public:
      MupLyrics(int,int,const char*);
      ~MupLyrics();
      char * text();
      char * lengths();
      MupLyrics * Next();
      void append(MupLyrics*);
    };
  
  class MupPhrase
    {
      Position start;
      Position end;
      MupPhrase * next;
      Part * master;
      int met0;
      int met1;
      char * help;
      
    public:
      MupPhrase(Position,int);
      ~MupPhrase();
      char * Range();
      MupPhrase * Next();
      void append(MupPhrase*);
    };

  MupLyrics * mupLyrics;
  MupPhrase * mupPhrase;
  
};

#endif
