#ifndef _REMOVEORNAMENT_CPP_
#define _REMOVEORNAMENT_CPP_

#include <iostream.h>

#include "removeOrnament.h"
#include "ornament.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "note.h"
#include "vector.h"

extern Song * sonG;

RemoveOrnament::RemoveOrnament(Note * note, Type t) : _note(note), _ornament_type(t), _hidden(0) {
  _type = REMOVEORNAMENT;
  _description = "remove ornament";
  _to_be_undone = true;
  if (_note) {
    switch (_ornament_type) {
    case EXPRESSION: _hidden = _note->removeExp(); break;
    case BOW: _hidden = _note->removeBow(); break;
    default: break;
    }
  }
}

RemoveOrnament::RemoveOrnament(const RemoveOrnament& o) : Operation(o) {
  _type = REMOVEORNAMENT;
  _note = (Note*) o._note->copy();
  _ornament_type = o._ornament_type;
  _hidden = (Vector*) o._hidden->copy();
}

RemoveOrnament::~RemoveOrnament() {
  if (_hidden) {
    delete _hidden; // destructor of compound calls scratch() !
  }
}

void RemoveOrnament::undo() {
  if (_hidden) {
    // for (int i=0; i<_hidden->size(); i++)
    _note->add((Ornament*)_hidden->first());
    _hidden->setContent(0);
    delete _hidden;
    _hidden = 0;
  }
}

void RemoveOrnament::redo() {
  if (_note) {
    switch (_ornament_type) {
    case EXPRESSION: _hidden = _note->removeExp(); break;
    case BOW: _hidden = _note->removeBow(); break;
    default: break;
    }
  }
}



// ---------------
// virtuals:
//

ostream & RemoveOrnament::print(int dep, ostream & s) const {
  s << spc(dep) << "<REMOVEORNAMENT note=\"" << _note << "\" type=\"" << _ornament_type << "\" />" << endl;
  return s;
}

void RemoveOrnament::flush(const char * c) const {
  cout << c << "REMOVEORNAMENT" << endl;
}

Element * RemoveOrnament::copy() const {
  return new RemoveOrnament(*this);
}




#endif
