#ifndef _SPLITPART_H_
#define _SPLITPART_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Part;

/** This operation splits a part at the position p
 */
class SplitPart : public Operation
{
 private:
  Part * _part;
  Part * _newpart;
  Position _relpos;

 public:
  SplitPart(Position p, Part * pt);
  SplitPart(const SplitPart&);
  ~SplitPart();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
