#ifndef _UNSELECT_CPP_
#define _UNSELECT_CPP_

#include <iostream.h>

#include "unselect.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

bool Unselect::empty() { return (selectioN->size()==0); }


Unselect::Unselect() : _oldTable(0) {
  _type = UNSELECT;
  _description = "unselect";
  _oldTable = selectioN;
  _delete = _oldTable;
  selectioN = new Table();
}


Unselect::Unselect(const Unselect& el) : Operation(el) {
  _type = UNSELECT;
  _oldTable = el._oldTable;
  _delete = el._delete;
}

Unselect::~Unselect() {
  if (_oldTable!=0) {
    ((Compound*)_oldTable)->scratch();
    delete _oldTable;
  }
}

void Unselect::undo() {
  Table * tmp = selectioN;
  selectioN = _oldTable;
  _oldTable = tmp;
  _delete = _oldTable;
}

void Unselect::redo() {
  Table * tmp = _oldTable;
  _oldTable = selectioN;
  selectioN = tmp;
  _delete = _oldTable;
}



// ---------------
// virtuals:
//

ostream & Unselect::print(int dep, ostream & s) const {
  s << spc(dep) << "<UNSELECT />" << endl;
  return s;
}

void Unselect::flush(const char * c) const {
  cout << c << "UNSELECT" << endl;
}

Element * Unselect::copy() const {
  return new Unselect(*this);
}




#endif
