#ifndef _KDEEDITORBUTTONBAR_CPP_
#define _KDEEDITORBUTTONBAR_CPP_

#include <stdio.h>
#include <iostream.h>

#include <kicontheme.h>
#include <kiconloader.h>

#include <qaccel.h>
#include <qcursor.h>
#include <qstring.h>

#include "kdeEditorButtonBar.h"
#include "kdeScoreEditor2.h"
#include "prPartEditor.h"



KdeEditorButtonBar::KdeEditorButtonBar( QWidget * parent, PrPartEditor * ed )
  : KToolBar( parent ), _editor(ed)
{
  KIconLoader *loader = KGlobal::iconLoader();

  pb[0] = new QPushButton( this ); pb[0]->setPixmap( loader->loadIcon( "nb1",KIcon::Toolbar ) );
  pb[1] = new QPushButton( this ); pb[1]->setPixmap( loader->loadIcon( "nb2",KIcon::Toolbar ) );
  pb[2] = new QPushButton( this ); pb[2]->setPixmap( loader->loadIcon( "nb4",KIcon::Toolbar ) );
  pb[3] = new QPushButton( this ); pb[3]->setPixmap( loader->loadIcon( "nb8",KIcon::Toolbar ) );
  pb[4] = new QPushButton( this ); pb[4]->setPixmap( loader->loadIcon( "nb16",KIcon::Toolbar ) );
  pb[5] = new QPushButton( this ); pb[5]->setPixmap( loader->loadIcon( "nb32",KIcon::Toolbar ) );
  pb[6] = new QPushButton( this ); pb[6]->setPixmap( loader->loadIcon( "nb64",KIcon::Toolbar ) );
  pb[7] = new QPushButton( this ); pb[7]->setPixmap( loader->loadIcon( "nbD",KIcon::Toolbar ) );
  pb[8] = new QPushButton( this ); pb[8]->setPixmap( loader->loadIcon( "nbT",KIcon::Toolbar ) );

  pb[9] = new QPushButton( this ); pb[9]->setPixmap( loader->loadIcon( "smFlat2",KIcon::Toolbar ) );
  pb[10] = new QPushButton( this ); pb[10]->setPixmap( loader->loadIcon( "smFlat",KIcon::Toolbar ) );
  pb[11] = new QPushButton( this ); pb[11]->setPixmap( loader->loadIcon( "smNo",KIcon::Toolbar ) );
  pb[12] = new QPushButton( this ); pb[12]->setPixmap( loader->loadIcon( "smSharp",KIcon::Toolbar ) );
  pb[13] = new QPushButton( this ); pb[13]->setPixmap( loader->loadIcon( "smSharp2",KIcon::Toolbar ) );

  // position
  QLabel * lPos = new QLabel("pos ",this);
  // lPos->setGeometry(14,2,30,18);
  insertWidget(-1,30,lPos);

  sprintf(position," - ");
  qlPosition = new QLabel(position,this);
  qlPosition->setFont(QFont("courier"));
  // qlPosition->setGeometry(44,2,82,18);
  qlPosition->setFixedWidth(102);
  insertWidget(-1,102,qlPosition);

  // freq
  QLabel * lFreq = new QLabel("freq ",this);
  // lFreq->setGeometry(132,2,40,18);
  insertWidget(-1,40,lFreq);

  sprintf(freq," - ");
  qlfreq = new QLabel(freq,this);
  // qlfreq->setGeometry(162,2,20,18);
  qlfreq->setFixedWidth(80);
  insertWidget(-1,80,qlfreq);

  // Note Lengths
  for (int i=0;i<9;i++) {
    // pb[i]->setGeometry(192+i*18, 2, 18, 18);
    pb[i]->setToggleButton(TRUE);
    insertWidget(-1,18,pb[i]);
    pb[i]->setFocusPolicy(QWidget::ClickFocus);
  }
  curlen = 3; pb[3]->setOn(TRUE);
  for (int i=0;i<7;i++) {
    connect(pb[i], SIGNAL(toggled(bool)),SLOT(noteToggle(bool))); pb[i]->setAccel(Qt::ALT + 49+i);
  }

  connect(pb[7], SIGNAL(toggled(bool)),SLOT(dotToggle(bool))); pb[7]->setAccel(Qt::ALT + Key_Period);
  connect(pb[8], SIGNAL(toggled(bool)),SLOT(triToggle(bool))); pb[8]->setAccel(Qt::ALT + Key_T);

  insertSeparator();

  // Enharmonic Shifts
  QLabel * lEnh = new QLabel("Enh.Shift ",this);
  // lEnh->setGeometry(192+10*18,2,54,18);
  insertWidget(-1,84,lEnh);
  for (int i=9;i<14;i++) {
    // pb[i]->setGeometry(278+i*18, 2, 18, 18);
    pb[i]->setToggleButton(TRUE);
    insertWidget(-1,18,pb[i]);
    pb[i]->setFocusPolicy(QWidget::ClickFocus);
    connect(pb[i], SIGNAL(toggled(bool)),SLOT(signToggle(bool)));
  }
  curenh = 0; pb[11]->setOn(TRUE);


  setCursor(QCursor(0));

}

void KdeEditorButtonBar::setLength(int ord, int dot, bool triplet) {
  ord--;
  if (curlen!=ord) {
    pb[ord]->setOn(TRUE);
  }
  if (pb[7]->isOn() != (dot>0)) pb[7]->toggle();
  if (pb[8]->isOn() != triplet) pb[8]->toggle();
}

void KdeEditorButtonBar::setPos(int a, int b, int c) {
  if (a+b+c>0) {
    sprintf(position,"%3d.%2d.%3d",a,b,c);
  } else {
    sprintf(position," - ");
  }  
  qlPosition->setText(position);
}

void KdeEditorButtonBar::setFreq(char c, int o, bool shft, bool ctrl) {
  char s = ' ';
  if (shft && (!ctrl)) s = '#';
  if (ctrl && (!shft)) s = 'b';
  if (s==' ') sprintf(freq,"%c%d",c,o);
  else sprintf(freq,"%c%c%d",c,s,o);
  qlfreq->setText(freq);
}

void KdeEditorButtonBar::setPitch(int p, bool shft, bool ctrl) {
  if ((0<p)&&(p<128)) {
    bool up = (shft && (!ctrl));
    bool dn = (ctrl && (!shft));
    if (dn) p++; // this is because pressing ctrl decrements the pitch automatically, which is not useful for this algorithm
    int n = p%12;
    char ff = 0;
    char sg = 0;
    switch (n) {
    case 0: ff = 'c'; sg = ' '; break;
    case 1: ff = 'c'; sg = '#'; break;
    case 2: ff = 'd'; sg = ' '; break;
    case 3: ff = 'd'; sg = '#'; break;
    case 4: ff = 'e'; sg = ' '; break;
    case 5: ff = 'f'; sg = ' '; break;
    case 6: ff = 'f'; sg = '#'; break;
    case 7: ff = 'g'; sg = ' '; break;
    case 8: ff = 'g'; sg = '#'; break;
    case 9: ff = 'a'; sg = ' '; break;
    case 10: ff = 'a'; sg = '#'; break;
    case 11: ff = 'h'; sg = ' '; break;
    }
    if (up) sg = '#';
    if (dn) sg = 'b';
    
    if (sg==' ') sprintf(freq,"%c%d",ff,(int)p/12-2);
    else sprintf(freq,"%c%c%d",ff,sg,(int)p/12-2);
    qlfreq->setText(freq);
  }
}

void KdeEditorButtonBar::noteToggle(bool on) {
  noteToggle(on, false);
}

void KdeEditorButtonBar::noteToggleGrid(bool on) {
  noteToggle(on, true);
}

void KdeEditorButtonBar::noteToggle(bool on, bool grid) {
  if (on==TRUE) {
    if (curlen != -1) pb[curlen]->setOn(FALSE);
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) curlen = i;
    }
    if (curlen==-1) curlen = 3;
    _editor->setLengthOrd(curlen+1);
    if (grid) _editor->setGrid(_editor->length());
    _editor->update();
  } else {
    int x = -1;
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) x = i;
    }
    if (x==-1) { x=curlen; curlen=-1; pb[x]->setOn(TRUE); }
  }
}

void KdeEditorButtonBar::dotToggle(bool on) {
  if (on==TRUE) {
    _editor->setDot(1);
  } else {
    _editor->setDot(0);
  }
}

void KdeEditorButtonBar::triToggle(bool on) {
  if (on==TRUE) {
    int v = 0;
    if (_editor->isScoreEditor()) {
      switch (((KdeScoreEditor2*)_editor)->tuplid()) {
      case ID_OPTIONS_TUPLETS_2: v = 2; break;
      case ID_OPTIONS_TUPLETS_3: v = 3; break;
      case ID_OPTIONS_TUPLETS_5: v = 5; break;
      case ID_OPTIONS_TUPLETS_7: v = 7; break;
      case ID_OPTIONS_TUPLETS_9: v = 9; break;
      case ID_OPTIONS_TUPLETS_11: v = 11; break;
      case ID_OPTIONS_TUPLETS_13: v = 13; break;
      case ID_OPTIONS_TUPLETS_15: v = 15; break;
      case ID_OPTIONS_TUPLETS_17: v = 17; break;
      case ID_OPTIONS_TUPLETS_19: v = 19; break;
      case ID_OPTIONS_TUPLETS_21: v = 21; break;
      }
      _editor->setTuplet(v);
    }
  } else {
    _editor->setTuplet(0);
  }
}

void KdeEditorButtonBar::signToggle(bool on) {
  if (on==TRUE) {
    if (curenh != -99) pb[curenh+11]->setOn(FALSE);
    for (int i=9;i<14;i++) {
      if (pb[i]->isOn()==TRUE) curenh = i-11;
    }
    if (curenh==-99) curenh = 0;
    _editor->setEnharmonicShift(curenh);
  } else {
    int x = -99;
    for (int i=9;i<14;i++) {
      if (pb[i]->isOn()==TRUE) x = i;
    }
    if (x==-99) { x=curenh; curenh=-99; pb[x+11]->setOn(TRUE); }
  }
}


#endif
#include "kdeEditorButtonBar.moc"
