#ifndef _KDEEDITORTOOLBAR_CPP_
#define _KDEEDITORTOOLBAR_CPP_

#include <stdio.h>
#include <iostream.h>

#include <kiconloader.h>
#include <kmenubar.h>
#include <klocale.h>

#include <qlabel.h>
#include <qlineedit.h>
#include <qstringlist.h>

#include "part.h"
#include "prPartEditor.h"
#include "prMainEditor.h"
#include "song.h"
#include "table.h"
#include "addon.h"
#include "copySelection.h"
#include "cutSelection.h"
#include "pasteSelection.h"
#include "deleteSelection.h"

#include "brahmsResources.h"
#include "kdeEditorToolBar.h"
#include "kdeMainEditor.h"

extern Song * sonG;
extern Table * selectioN;
extern Table * selectionMemory;
extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)



KdeEditorToolBar::KdeEditorToolBar(QWidget * parent, PrPartEditor * ed)
  : KToolBar(parent), _editor(ed), _inspos(0), _action(0), _limit(sonG->currentOp())
{

  KIconLoader * loader = KGlobal::iconLoader();

  QStringList qslist;
  int actionEntries = 0;
  char ** alist = ME->actionList();
  for (int i=0;i<MAXACTIONS;i++) if ((alist[i]!=0) && ((ME->actionContext(i)&Addon::TREAT_SELECTION) || (ME->actionContext(i)&Addon::TREAT_PART))) {
    qslist.append(alist[i]);
    nlist[actionEntries++] = i;
  }

  /*
  insertButton( loader->loadIcon( "start", KIcon::Toolbar), ID_PANEL_BACK, TRUE, i18n("Back to Start"));
  insertButton( loader->loadIcon( "back", KIcon::Toolbar), ID_PANEL_REWIND, TRUE, i18n("Rewind"));
  insertButton( loader->loadIcon( "forward", KIcon::Toolbar), ID_PANEL_FORWARD, TRUE, i18n("Forward"));
  insertSeparator();
  insertSeparator();
  */
  insertButton( loader->loadIcon( "undo", KIcon::Toolbar), ID_EDIT_UNDO, TRUE, i18n("Undo"));
  insertButton( loader->loadIcon( "redo", KIcon::Toolbar), ID_EDIT_REDO, TRUE, i18n("Redo"));
  setItemEnabled( ID_EDIT_UNDO, FALSE );
  setItemEnabled( ID_EDIT_REDO, FALSE );
  insertSeparator();
  insertSeparator();
  insertButton( loader->loadIcon( "editcopy", KIcon::Toolbar), ID_EDIT_COPY, TRUE, i18n("Copy"));
  insertButton( loader->loadIcon( "editcut", KIcon::Toolbar), ID_EDIT_CUT, TRUE, i18n("Cut"));
  insertButton( loader->loadIcon( "editpaste", KIcon::Toolbar), ID_EDIT_PASTE, TRUE, i18n("Paste"));
  insertButton( loader->loadIcon( "edittrash", KIcon::Toolbar), ID_EDIT_CLEAR, TRUE, i18n("Delete"));
  // insertButton( loader->loadIcon( "goto", KIcon::Toolbar), ID_EDIT_TRANSPOSE, TRUE, i18n("Transpose"));
  insertButton( loader->loadIcon( "fileprint", KIcon::Toolbar), ID_EDIT_PRINT, TRUE, i18n("Print"));
  setItemEnabled( ID_EDIT_COPY, FALSE );
  setItemEnabled( ID_EDIT_CUT, FALSE );
  setItemEnabled( ID_EDIT_PASTE, FALSE );
  setItemEnabled( ID_EDIT_CLEAR, FALSE );
  setItemEnabled( ID_EDIT_TRANSPOSE, FALSE );
  insertSeparator();
  insertSeparator();
  // insertWidget( -2, 40, new QLabel("Action:", this) );
  insertCombo( qslist, ID_EDIT_ACTION_LIST, FALSE, SIGNAL(highlighted(int)), this, SLOT(slotActionList(int)), TRUE, "action",32 );
  if (actionEntries==0) setItemEnabled( ID_EDIT_ACTION_LIST, FALSE );
  insertButton( loader->loadIcon( "run", KIcon::Toolbar), ID_EDIT_ACTION_GO, TRUE, i18n("perform action") );
  if (actionEntries==0) setItemEnabled( ID_EDIT_ACTION_GO, FALSE );
  insertSeparator();
  insertSeparator();
  insertButton( loader->loadIcon( "viewmag+", KIcon::Toolbar), ID_EDIT_PLUSH, TRUE, i18n("Enlarge View Horizontally"));
  insertButton( loader->loadIcon( "viewmag-", KIcon::Toolbar), ID_EDIT_MINUSH, TRUE, i18n("Shrink View Horizontally"));
  insertSeparator();
  insertSeparator();
  // insert point:
  insertWidget(-2,32,new QLabel("Insert:",this));
  insLine = new QLineEdit( this,"-" );
  insLine->setText("  1 .1 .0");
  insLine->setFocusPolicy(QWidget::ClickFocus);
  insLine->show();
  insLine->setEnabled(TRUE);
  insertWidget(ID_EDIT_INSERT,32,insLine);
  connect(insLine,SIGNAL(returnPressed()),SLOT(slotInsertPoint()));

  insertButton( loader->loadIcon( "speaker", KIcon::Toolbar), ID_EDIT_SPEAKER, TRUE, i18n("speaker on/off"));
  setToggle(ID_EDIT_SPEAKER, TRUE);
  setButton(ID_EDIT_SPEAKER, _editor->speaker());

  insertButton( loader->loadIcon( "paintbrush", KIcon::Toolbar), ID_EDIT_COLOR, TRUE, i18n("colorize channels on/off"));
  setToggle(ID_EDIT_COLOR, TRUE);
  setButton(ID_EDIT_COLOR, _editor->color());

  insertSeparator();
  insertSeparator();
  insertButton( loader->loadIcon( "exit", KIcon::Toolbar), ID_FILE_CLOSE, TRUE, i18n("Leave Editor"));

  connect(this,SIGNAL(clicked(int)), SLOT(commandCallback(int)));

  show();
}

void KdeEditorToolBar::slotActionList(int i) {
  _action = nlist[i];
}

void KdeEditorToolBar::slotInsertPoint() {
  sprintf(_insposc,"%s",insLine->text().latin1());
  _inspos = Position(_insposc,0).ticks();
  insLine->clearFocus();
}

Part * KdeEditorToolBar::part() {
  return _editor->part();
}

void KdeEditorToolBar::setInsertPoint(long p) {
  int bar=0; int beats=0; int ticks=0;
  _inspos = p;
  sonG->bbt(bar,beats,ticks,Position(p));
  sprintf(_insposc,"%3d.%2d.%3d",bar,beats,ticks);
  insLine->setText(_insposc);
}

void KdeEditorToolBar::commandCallback(int id_)
{
  switch (id_) {
    /*
  case ID_PANEL_BACK:
    _editor->update();
    break;
  case ID_PANEL_REWIND:
    _editor->moveright(1);
    _editor->update();
    break;
  case ID_PANEL_FORWARD:
    _editor->moveleft(1);
    _editor->update();
    break;
    */
  case ID_FILE_SETTINGS:
    _editor->settings();
    break;
  case ID_EDIT_UNDO:
    if ( _limit != sonG->currentOp() ) {
      sonG->undo();
      _editor->update();
      if ( _limit == sonG->currentOp() ) setItemEnabled( ID_EDIT_UNDO, FALSE );
    }
    break;
  case ID_EDIT_REDO:
    sonG->redo();
    _editor->update();
    break;
  case ID_EDIT_COPY:
    sonG->doo(new CopySelection());
    _editor->update();
    break;
  case ID_EDIT_CUT:
    sonG->doo(new CutSelection(_editor->part()));
    _editor->update();
    break;
  case ID_EDIT_CLEAR:
    sonG->doo(new DeleteSelection(_editor->part()));
    _editor->update();
    break;
  case ID_EDIT_PASTE:
    sonG->doo(new PasteSelection(_editor->part(),_inspos));
    _editor->update();
    break;
  case ID_EDIT_TRANSPOSE:

    _editor->update();
    break;
  case ID_EDIT_PRINT:
    _editor->print();
    break;
  case ID_EDIT_ACTION_GO:
    if (ME->actionList()[0] != 0) {
      if (selectioN->first() != 0 && selectioN->first()->isEvent()) ME->performAction( _action, 0 );
      else                                                          ME->performAction( _action, _editor->part() );
    }
    break;
  case ID_EDIT_PLUSH:
    _editor->zoomin();
    // _editor->update();
    break;
  case ID_EDIT_MINUSH:
    _editor->zoomout();
    // _editor->update();
    break;
  case ID_EDIT_INSERT:
    
    break;
  case ID_EDIT_SPEAKER:
    if (_editor->speaker()) _editor->setSpeaker(false);
    else _editor->setSpeaker(true);
    setButton(ID_EDIT_SPEAKER,_editor->speaker());
    break;
  case ID_EDIT_COLOR:
    if (_editor->color()) _editor->setColor(false);
    else _editor->setColor(true);
    setButton(ID_EDIT_COLOR,_editor->color());
    _editor->update();
    break;
  case ID_FILE_CLOSE:
    delete _editor;
    break;

  }
}

#endif
#include "kdeEditorToolBar.moc"
