#ifndef _KDEKEYCHOOSER_C_
#define _KDEKEYCHOOSER_C_

#include <iostream.h>

#include <stdio.h>
#include <stdlib.h>
#include <kiconloader.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qpainter.h>

#include "kdeKeyChooser.h"
#include "kdeScoreEditor2.h"
#include "kdeScoreContent2.h"

#include "part.h"
#include "prPartEditor.h"

extern int sharpTab[];
extern int signShift[];
extern int flatTab[];


KdeKeyChooser::KdeKeyChooser( PrPartEditor * pe )
  : QLabel(0,"Chooser",WStyle_Customize | WStyle_DialogBorder), part(pe->part()),
    key(part->key()), clef(part->clef()), time1(part->meter0()), time2(part->meter1()), _editor((KdeScoreEditor2*)pe)
{
  setCaption("Chooser");

  KIconLoader * loader = KGlobal::iconLoader();

  setBackgroundMode( PaletteLight );
  setFixedSize(170,80);
  QPushButton * clefU = new QPushButton( this ); clefU->setPixmap( loader->loadIcon("up.xpm",KIcon::Toolbar) ); clefU->setGeometry(0,0,20,30);
  QPushButton * clefD = new QPushButton( this ); clefD->setPixmap( loader->loadIcon("down.xpm",KIcon::Toolbar) ); clefD->setGeometry(0,30,20,30);
  QPushButton * keyU = new QPushButton( this ); keyU->setPixmap( loader->loadIcon("up.xpm",KIcon::Toolbar) ); keyU->setGeometry(150,0,20,30);
  QPushButton * keyD = new QPushButton( this ); keyD->setPixmap( loader->loadIcon("down.xpm",KIcon::Toolbar) ); keyD->setGeometry(150,30,20,30);
  // QSpinBox * num = new QSpinBox( 1,20,1,this ); num->setGeometry(170,0,25,30); num->setValue(time1);
  // QSpinBox * nom = new QSpinBox( 1,5,1,this ); nom->setGeometry(170,30,25,30); nom->setValue(time2);
  QPushButton * ok = new QPushButton( this ); ok->setPixmap( loader->loadIcon("exit.xpm",KIcon::Toolbar) ); ok->setGeometry(0,60,170,20);

  connect(clefU,SIGNAL(pressed()),SLOT(incClef()));
  connect(clefD,SIGNAL(pressed()),SLOT(decClef()));
  connect(keyU,SIGNAL(pressed()),SLOT(incKey()));
  connect(keyD,SIGNAL(pressed()),SLOT(decKey()));
  // connect(num,SIGNAL(valueChanged(int)),SLOT(updateNum(int)));
  // connect(nom,SIGNAL(valueChanged(int)),SLOT(updateNom(int)));
  connect(ok,SIGNAL(pressed()),SLOT(ok()));

  clefU->show(); clefD->show(); keyU->show(); keyD->show(); ok->show();

}

KdeKeyChooser::~KdeKeyChooser() {
  _editor->content()->clearKeyChooser();
}

void KdeKeyChooser::paintEvent ( QPaintEvent * ) {
  time1 = part->meter0();
  time2 = part->meter1();
  sprintf(t1, "%d", time1);
  sprintf(t2, "%d", time2);
  QPainter painter;
  painter.begin(this);
  painter.drawPixmap(28,12,((KdeScoreEditor2*)_editor)->content()->imgClef[clef]); // draw Clef
  painter.drawLine(28,20,28,44);
  painter.drawLine(140,20,140,44);
  for (int i=0;i<5;i++)
    painter.drawLine(28,20+i*6,150,20+i*6);
    
  int nKey = abs(key);
  for (int i=0; i<nKey; i++) {
    if (key>0) { painter.drawPixmap(75+i*6-8, 9+(sharpTab[i]+signShift[clef])*3, ((KdeScoreEditor2*)_editor)->content()->imgSharp); // draw sharps
    } else { painter.drawPixmap(75+i*6-8, 7+(flatTab[i]+signShift[clef])*3, ((KdeScoreEditor2*)_editor)->content()->imgFlat);      // draw flats
    }
  }
  painter.setFont(QFont("Helvetica",12,QFont::Bold));
  painter.drawText(125,31,t1);  // draw measurement
  painter.drawText(125,43,t2); 

  painter.end();
  
}

void KdeKeyChooser::incClef() {
  clef++;
  if (clef==14) clef=0;
  repaint();
}

void KdeKeyChooser::decClef() {
  clef--;
  if (clef==-1) clef=13;
  repaint();
}

void KdeKeyChooser::incKey() {
  key++;
  if (key==8) key=-7;
  repaint();
}

void KdeKeyChooser::decKey() {
  key--;
  if (key==-8) key=7;
  repaint();
}

void KdeKeyChooser::ok() {
  part->setKey(key);
  part->setClef(clef);
  part->setMeter(time1,time2);
  //scanvas->scrKey = key);
  //scanvas->clef = clef);
  _editor->update();
  delete this;
}

void KdeKeyChooser::updateNum(int n) {
  time1=n;
  repaint();
}

void KdeKeyChooser::updateNom(int n) {
  time2=n;
  repaint();
}


#endif
#include "kdeKeyChooser.moc"
