#ifndef _KDEPARTEDITOR_CPP_
#define _KDEPARTEDITOR_CPP_

#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <math.h>

#include "part.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "position.h"
#include "addElement.h"

#include "kdePartEditor.h"
#include "kdeProgress.h"

extern Song * sonG;

KdePartEditor::KdePartEditor() : PrPartEditor(EVENTEDITOR) {

}

KdePartEditor::KdePartEditor(Part * p) : PrPartEditor(p) {
  run();
}

KdePartEditor::KdePartEditor(Track * t) : PrPartEditor(t) {
  run();
}

KdePartEditor::~KdePartEditor() {

}

void KdePartEditor::run() {
  
  char line[400];
  const char * cmd;
  bool exit = false;
  update();
  while (!exit) {
    cout << "\n[ " << part()->size() << " ] $ ";
    cin.getline(line,400,'\n');
    Vector vec = Vector(line);
    cmd = ((String*) (vec)[0])->getValue();
    if (strcmp(cmd,"")==0) { update(); }
    if (strcmp(cmd,"help")==0) {
      cout << endl;
      cout << " help       - shows this list" << endl;
      cout << " exit       - leaves the edit mode" << endl;
      cout << " +          - moves one bar to the right" << endl;
      cout << " -          - moves one bar to the left" << endl;
      cout << " zoomin     - zooms in" << endl;
      cout << " zoomout    - zooms out" << endl;
      cout << " up         - activates one track up" << endl;
      cout << " down       - activates one track below" << endl;
      cout << " add pos pitch len - adds a note to the part" << endl;
      cout << " play       - plays the part" << endl;
    }
    if (strcmp(cmd,"exit")==0) { exit = true; }
    if (strcmp(cmd,"-")==0) { moveright(1); }
    if (strcmp(cmd,"+")==0) { moveleft(1); }
    if (strcmp(cmd,"zoomin")==0) { zoomin(); }
    if (strcmp(cmd,"zoomout")==0) { zoomout(); }
    if (strcmp(cmd,"up")==0) { moveUp(); }
    if (strcmp(cmd,"down")==0) { moveDown(); }
    //    if (strcmp(cmd,"play")==0) { sonG->play(new KdeProgress(),part(),_leftPos.ticks(),_rightPos.ticks()); }
    if (strcmp(cmd,"add")==0) {
      // for example: "add 1.1.0 c4 192"
      const char * newpos = ((String*) (vec)[1])->getValue();
      const char * newpitch = ((String*) (vec)[2])->getValue();
      int newlen = atoi(((String*) (vec)[3])->getValue());
      cout << "added note " << newpos << ":" << newpitch << ":" << newlen << endl;
      long int vel = 100;
      Note * n = new Note((char*)newpitch,vel,newlen,Position((char*)newpos,0),0);
      sonG->doo(new AddElement(n,part()));

    }
  }
}


void KdePartEditor::update() {
  // cout << "\ec" << endl;
  cout << "Part Editor\n" << endl;
  Part * pt = part();
  if (pt) {
    cout << "Track: " << name() << endl;
    cout << "Key: " << pt->key() << "  Clef: " << pt->clef() << "  Meter: " << pt->meter0() << "/" << pt->meter1() << endl;
    /* JAN
    rewind();
    cout << "Range: " << cLeft() << " - " << cRight() << endl << endl;
    bool ok = true;
    while (ok) {
      pt->flushCurrent();
      ok = currentInc();
      }*/
  } else {
    cout << "no part in track" << endl;
  }
}








#endif
