#ifndef _KDESCOREEDITOR_H_
#define _KDESCOREEDITOR_H_

#include <kmainwindow.h>

#include "prScoreEditor.h"

class Track;
class Part;
class Note;
class Lyrics;
class ScoreGroup;
class QPopupMenu;
class QSplitter;
class QScrollView;
class QScrollBar;
class QWidget;
class QFrame;
class QPaintEvent;
class QResizeEvent;
class KdeEditorToolBar;
class KdeEditorNoteBar;
class KdeEditorButtonBar;
class KdeEditorScrollBar;
class KdeEditInfo;
class KdeScoreContent;

class KdeScoreEditor : public KMainWindow, public PrScoreEditor
{
  // friend QtChooser;
  // friend QtSymbols;
  // friend QtSPD;

  Q_OBJECT

 private:
  QSplitter       * _splitter;
  // QWidget         * _area;
  QScrollView     * _scroller;
  KdeEditorToolBar * _toolbar;
  KdeEditorNoteBar * _notebar;
  KdeEditorButtonBar * _buttonbar;
  KdeEditorScrollBar * _scrollbar;
  KdeScoreContent * _content;
  KdeEditInfo * _info;
  QPopupMenu      * _filemenu;
  QPopupMenu      * _editmenu;
  QPopupMenu      * _gridmenu;
  QPopupMenu      * _dynamicsmenu;
  QPopupMenu      * _viewmenu;
  QPopupMenu      * _toolmenu;
  QPopupMenu      * _optionsmenu;
  int _yoffset;
  int _ybottom;
  int _grid_id;
  int _dyn_id;
  bool _toolbarstate;
  bool _notebarstate;
  bool _buttonbarstate;
  bool _sliderstate;
  int _tool;
  bool showIN;
  bool showTN;
  bool showLYR;
  bool showVOL;
  // QPopupMenu * rbmenu;
  bool showAUX;
  bool showNEXT;
  /*
  QtSymbols * scoreAux;
  QtSymbols * noteExt;
  QPixmap imgSign[6];
  QPixmap imgNote[2];
  QPixmap imgClef[15];
  QPixmap arrBreak[10];
  QPixmap imgFlat;
  QPixmap imgSharp;
  QPixmap imgFlag[2];
  QPixmap noteAccent[21];
  QPixmap scoreSymbol[33];
  QPixmap cursorPM;
  QBitmap cursorBM[9];
  QCursor * cursor[9];
  Part * _part;
  Part * master;
  int _grid_id;
  int _dyn_id;
  double pixPerTick;
  double posCoef;
  int yAux;
  int enhValue;
  int yytext;
  int scrKey;
  int clef;
  int nKey;
  int yoffset;
  int xoffset;
  int xofftime;
  char t1[5];
  char t2[5];
  int met0;
  int met1;
  int curMet0;
  int curMet1;

  int draw(Position lpos, Position rpos, QPainter * score);
  int DOT(int);
  // old stuff:

  void showFreq();
  int Pitch(int);
  void createLyrics(Note*,int,int);
  // void createText(KbAuxElement*,int,int);

  Note * lyricsNote;
  Part * lyricsPart;
  Lyrics * oldLyr;
  int N;
  int y;
  Position freePos;
  Position brkPos;
  // KbPosition oldFreePos;
  int ticksPerBar;
  int brk;
  int timeDelta;
  int xb;
  int system;
  int yOff;
  int ySys;
  int ySysGrab;

  // KbPosition xLeft;
  // KbPosition xRight;
  int oldCurBar;
  int curBar;
  int curBeat;
  int curTick;
  int leftBar;
  int leftBeat;
  int leftTick;
  int leftMet0;
  int leftMet1;

  int oldTimeBar;
  int n;
  int scrClef;
  int i;
  int j;
  int k;
  int yyOld;
  int xxOld;
  int xxCol;
  int yFlag1;
  double nFlag[24];
  double nFlag1;
  int nnFlag1;
  int xFlag[24];
  int yFlagMax[24];
  int yFlag1Max;
  int yFlagMin[24];
  int yFlag1Min;
  int yyyMin;
  int yyyMax;
  int flag;
  int maxNnFlags;
  int triX0;
  int scorelength;
  int freq;
  int oldfreq;
  int vel;
  int len;
  int enh;
  int chan;
  int stemDir;
  Note * next;
  double deltapos;
  int step;
  int yy;
  int sg;
  int xx;
  int sgMem;
  int xxShft;
  QPixmap img;
  int akkordmin;
  int akkordmax;
  int akkordmaxOld;
  int akkordlen;
  int dot;
  int triMem;
  int triYmax;
  int triYmin;
  int triDX;
  double cl;
 
  int x0; int x1; int x2;
  QPen flagPen;
  int neck;

  double xBrk[5];
  double llBrk[5];
  int bb;
  // int x0; int x1; int x2;
  int volGrabX1;
  int volGrabX2;
  int volGrabY1;
  int volGrabY2;
  // Buttonbar * buttonbar;
  // QtSPD * myPrintDialog;
  QLineEdit * lyrLine;
  QLineEdit * txtLine;
  int extNoteElement;
  int auxScoreElement;
  Note * extNote;
  int extNoteParameter;
  //Exp * noteExp;
  //Bow * noteBow;
  //KbAuxElement * auxEl;
  ScoreGroup * firstGroup;
  */

 public:
  KdeScoreEditor();
  KdeScoreEditor(Track*);
  KdeScoreEditor(Part*);

  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);
  void run();

  bool showInstrumentName();
  bool showTrackName();
  KdeScoreContent * content();

  // old:
  int gEnhValue();
  void sEnhValue(int e);
  void updateCursor();
  void setTool(int);
  int  tool();
  void addMenuEntries();
  // void settings();

 public slots:
  void paintEvent( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  //void mousePressEvent ( QMouseEvent * );
  //void mouseMoveEvent  ( QMouseEvent * );
  //void mouseReleaseEvent ( QMouseEvent * );
  void keyPressEvent ( QKeyEvent * );
  void keyReleaseEvent ( QKeyEvent * );
  void toolMenu(int);
  void optionsMenu(int);
  
  /*
  void setLyrics();
  void setText();
  void removeSymbols();
  void removeBow();
  void flipStem();
  void flipBow();
  */
  void slotMenu( int );
  void slotGridMenu( int );
  void slotDynMenu( int );
  void slotViewMenu( int );
};

#endif
