#ifndef _KDETRACK_CPP_
#define _KDETRACK_CPP_

#include <iostream.h>

#include <qpixmap.h>
#include <qbitmap.h>
#include <qmessagebox.h>

#include <kicontheme.h>
#include <kiconloader.h>


#include "kdePart.h"
#include "kdeTrack.h"
#include "kdeMainEditor.h"
#include "togButton.h"
#include "typeChooser.h"
#include "trackLabel.h"

#include "prMainEditor.h"
#include "song.h"
#include "track.h"
#include "part.h"
#include "str.h"
#include "table.h"

extern Table * selectioN;

extern PrMainEditor * mainEditor;
#define ME ((KdeMainEditor*)mainEditor)

extern Song * sonG;

static unsigned char ccc[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};


KdeTrack::KdeTrack(Track * tr)
  : QWidget(ME->left()),
    _track(tr)
{
  _icon = new QPixmap(*ccc);
  KIconLoader * loader = KGlobal::iconLoader();

  QPixmap * pmLock = new QPixmap(loader->loadIcon( "key", KIcon::Toolbar )); pmLock->setMask(pmLock->createHeuristicMask());
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute", KIcon::Toolbar ));

  _mute = new TogButton( pmMute, 0, this, "mute" );
  _mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _mute->setGeometry(0,0,24,ME->trackHeight()-1);

  _type = new TypeChooser(this);
  _type->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _type->setGeometry(24,0,24,ME->trackHeight()-1);

  _lock = new TogButton( pmLock, 0, this, "lock" );
  _lock->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _lock->setGeometry(48,0,24,ME->trackHeight()-1);

  _name = new TrackLabel(this);
  _name->setText(_track->name()->getValue());
  _name->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _name->setGeometry(72,0,96,ME->trackHeight()-1);

  setGeometry(0,0,1,1);
}

void KdeTrack::update(bool menu) {
  int n = _track->ord(sonG);
  int ww = 632;
  int hh = ME->trackHeight();
  setGeometry(0,n*hh,ww,hh);
  
  if (menu) _name->buildMenu();
  
  _mute->setState(_track->mute());
  _lock->setState(_track->lock());
  _name->setText(_track->name()->getValue());
  _type->update();
  if (selectioN->hasEntry(_track)) _name->setBackgroundMode(QWidget::PaletteLight);
  else                             _name->setBackgroundMode(QWidget::PaletteBackground);
  
  for (Part * pt = (Part*) _track->first(); pt != 0; pt = (Part*) _track->next(pt)) pt->presentation()->update(menu);
}

void KdeTrack::updateCore() {
  _track->setMute(_mute->state());
  _track->setLock(_lock->state());
}

void KdeTrack::erase() { // this is called from the core destructor
  delete this;
}

void KdeTrack::hide() {
  QWidget::hide();
}

void KdeTrack::show() {
  QWidget::show();
}


QPixmap * KdeTrack::pixmap() {
  return _icon;
}

Track * KdeTrack::track() { return _track; }

#endif
#include "kdeTrack.moc"
