#ifndef _TYPECHOOSER_CPP_
#define _TYPECHOOSER_CPP_

#include <kiconloader.h>

#include <qpopupmenu.h>

#include "typeChooser.h"
#include "brahmsResources.h"
#include "kdeTrack.h"
#include "kdeMainEditor.h"

#include "track.h"
#include "convertTrack.h"
#include "song.h"
#include "prMainEditor.h"


extern Song * sonG;
extern PrMainEditor * mainEditor;
#define ME ((KdeMainEditor*)mainEditor)


TypeChooser::TypeChooser( QWidget * parent, const char * name )
  : QLabel(parent,name), _track((KdeTrack*)parent)
{
  KIconLoader * loader = KGlobal::iconLoader();

  pmDrum = new QPixmap(loader->loadIcon( "drum", KIcon::Toolbar ));
  pmTime = new QPixmap(loader->loadIcon( "time", KIcon::Toolbar ));
  pmScor = new QPixmap(loader->loadIcon( "note", KIcon::Toolbar ));
  pmWave = new QPixmap(loader->loadIcon( "wav", KIcon::Toolbar ));
  pmComm = new QPixmap(loader->loadIcon( "comment", KIcon::Toolbar ));
  
  menu = new QPopupMenu;
  menu->setMouseTracking( TRUE );
  /* menu->connectItem( menu->insertItem(*pmScor,"Score Track",ID_SCORE), this, SLOT(chooseScore()) );
  menu->connectItem( menu->insertItem(*pmDrum,"Drum Track",ID_DRUM), this, SLOT(chooseDrum()) );
  menu->connectItem( menu->insertItem(*pmTime,"Mastertrack",ID_MASTER), this, SLOT(chooseMaster()) );
  menu->connectItem( menu->insertItem(*pmWave,"Audio Track",ID_AUDIO), this, SLOT(chooseWave()) );
  menu->connectItem( menu->insertItem(*pmComm,"Comment",ID_TEXT), this, SLOT(chooseComment()) );*/

  menu->insertItem(*pmScor,"Score Track",ID_SCORE);
  menu->insertItem(*pmDrum,"Drum Track",ID_DRUM);
  menu->insertItem(*pmTime,"Mastertrack",ID_MASTER);
  menu->insertItem(*pmWave,"Audio Track",ID_AUDIO);
  menu->insertItem(*pmComm,"Comment",ID_TEXT);
  
  char * nam = 0;
  for (int i=0; (nam = mainEditor->description(i))!=0; i++) {
    if (mainEditor->actionTrack(i)!=0) menu->insertItem(*_track->pixmap(), nam, 5+i);
  }
  connect(menu, SIGNAL(activated(int)), SLOT(chooseExt(int)));
  
  setAlignment(AlignCenter);
  update();
}

void TypeChooser::update() {
  
  QPixmap * pm = _track->pixmap();
  setPixmap(*pm);
}

void TypeChooser::chooseExt(int i) {
  switch (i) {
  case ID_SCORE:  sonG->doo(new ConvertTrack(0,_track->track(),sonG)); break;
  case ID_DRUM:   sonG->doo(new ConvertTrack(1,_track->track(),sonG)); break;
  case ID_MASTER: sonG->doo(new ConvertTrack(2,_track->track(),sonG)); break;
  case ID_AUDIO:  sonG->doo(new ConvertTrack(3,_track->track(),sonG)); break;
  case ID_TEXT:   sonG->doo(new ConvertTrack(4,_track->track(),sonG)); break;
  default:  sonG->doo(new ConvertTrack(i,_track->track(),sonG));
  }
  ME->update();
}

void TypeChooser::mousePressEvent ( QMouseEvent * mouse ) {
  menu->popup( mapToGlobal(mouse->pos()), 0 );
}

/*void TypeChooser::chooseDrum() { sonG->doo(new ConvertTrack(1,_track->track(),sonG)); ME->update(); }

void TypeChooser::chooseMaster() { sonG->doo(new ConvertTrack(2,_track->track(),sonG)); ME->update(); }

void TypeChooser::chooseScore() { sonG->doo(new ConvertTrack(0,_track->track(),sonG)); ME->update(); }

void TypeChooser::chooseWave() { sonG->doo(new ConvertTrack(3,_track->track(),sonG)); ME->update(); }

void TypeChooser::chooseComment() { sonG->doo(new ConvertTrack(4,_track->track(),sonG)); ME->update(); }
*/

#endif
#include "typeChooser.moc"
