#ifndef _TEXTSCOREPAINTER_CPP_
#define _TEXTSCOREPAINTER_CPP_

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "scoreBar.h"
#include "scoreGroup.h"
#include "scoreChord.h"
#include "scoreBreak.h"
#include "note.h"
#include "reference.h"
#include "screen.h"

#include "textScorePainter.h"
#include "textScoreEditor.h"


char imgSigns[] = { 'B', 'b', 'n', '#', 'x', 'n' };


TextScorePainter::TextScorePainter() {}


int TextScorePainter::drawInfo(ScoreBar * bar, Screen * screen, int off) {
  int indent = 0;

  //
  // Draw Clef:
  // **********
  //
  clef = bar->clef();
  if (clef==0) {
    screen->put(off+indent+3,4,'*');
    screen->put(off+indent+2,5,'*'); screen->put(off+indent+4,5,'*');
    screen->put(off+indent+2,6,'*'); screen->put(off+indent+4,6,'*');
    screen->put(off+indent+2,7,'*'); screen->put(off+indent+3,7,'*');
    screen->put(off+indent+2,8,'*'); screen->put(off+indent+3,8,'*');
    screen->put(off+indent+1,9,'*'); screen->put(off+indent+3,9,'*');
    screen->put(off+indent,10,'*'); screen->put(off+indent+2,10,'*'); screen->put(off+indent+3,10,'*'); screen->put(off+indent+4,10,'*');
    screen->put(off+indent,11,'*'); screen->put(off+indent+1,11,'*'); screen->put(off+indent+3,11,'*'); screen->put(off+indent+5,11,'*');
    screen->put(off+indent+1,12,'*'); screen->put(off+indent+2,12,'*'); screen->put(off+indent+3,12,'*'); screen->put(off+indent+4,12,'*');
    screen->put(off+indent+3,13,'*');
    screen->put(off+indent+1,14,'*'); screen->put(off+indent+2,14,'*'); screen->put(off+indent+3,14,'*');
    screen->put(off+indent+1,15,'*'); screen->put(off+indent+2,15,'*');
    indent += 7;
  } else if (clef==1) {
    screen->put(off+indent+1,6,'*'); screen->put(off+indent+2,6,'*'); screen->put(off+indent+3,6,'*'); screen->put(off+indent+4,6,'*'); screen->put(off+indent+7,6,'*');
    screen->put(off+indent,7,'*'); screen->put(off+indent+1,7,'*'); screen->put(off+indent+2,7,'*'); screen->put(off+indent+5,7,'*');
    screen->put(off+indent+1,8,'*'); screen->put(off+indent+5,8,'*'); screen->put(off+indent+7,8,'*');
    screen->put(off+indent+5,9,'*');
    screen->put(off+indent+4,10,'*');
    screen->put(off+indent+3,11,'*');
    screen->put(off+indent+2,12,'*');
    indent += 9;
  }

  //
  // Draw Key:
  // *********
  //
  key = bar->key();
  
  for (int i=0; i<abs(key); i++) {
    if (key>0)  screen->put(off+indent+i, 5 + sharpTab[i] + signShift[clef], '#');  // draw sharps
    else        screen->put(off+indent+i, 5 + flatTab[i] + signShift[clef], 'b');   // draw flats
  }
  if (key!=0) indent += abs(key)+1;

  //
  // Draw Meter:
  // ***********
  //
  screen->text(off+indent+2, 8, string(bar->meter(0)));
  screen->text(off+indent+2, 10, string(bar->meter(1)));
  indent += 3;

  //
  // Draw Program:
  // *************
  //
  int prg = bar->program();
  screen->text(off+2, 0, programName(prg));

  //
  // Draw Position:  
  // **************
  //
  screen->text(off+2, 1, bar->position());

  return indent;
}

int TextScorePainter::indentSystem(ScoreBar * bar) {
  if (bar->clef()==-1) return 2;
  else return abs(bar->key()) + 6;
}

// *********************************************
// **                                         **
// **                                         **
// **                  BAR                    **
// **                                         **
// **                                         **
// *********************************************


void TextScorePainter::paintBar(ScoreBar * bar, PrScoreEditor * ed, Table * grps, int xoff, int yoff, int) {
  //
  // the indent is the space between the left position of the bar and the position of the first element
  // within the bar. Don't get it mixed up with the offset xoff, which specifies the position of the bar.
  //
  int indent = 0;

  int num = ed->numberOfBars();

  Screen * screen = ((TextScoreEditor*)ed)->screen();
  int width = int(screen->width()*1.0/num);

  for (int i=0; i<5; i++) screen->draw(xoff, yoff+i*2+5, xoff+width, yoff+i*2+5);
  screen->draw(xoff, yoff+5+1, xoff, yoff+5+7);
  screen->draw(xoff+width, yoff+5+1, xoff+width, yoff+5+7);
  
  indent +=2;
  
  //
  // this shall be done only for the first bar inside a part:
  //
  if (bar->clef() != -1) indent += drawInfo(bar, screen, xoff+indent);

  //
  // now we can calculate the coefficient
  //
  unitsPerTick = (width-indent)*1.0/bar->duration();
  xoff += indent;

  //
  // reset signs
  //
  resetSigns(key);

  long left = bar->start().ticks();
  for (int i=0; i<grps->size(); i++) {
    ScoreGroup * grp = (ScoreGroup*) grps->get(i);
    int deltax = int((grp->start() - left) * unitsPerTick);  
    grp->paint(ed, deltax + xoff+2, yoff);
  }
}



// *********************************************
// **                                         **
// **                                         **
// **                 GROUP                   **
// **                                         **
// **                                         **
// *********************************************


void TextScorePainter::paintGroup(ScoreGroup * group, PrScoreEditor * ed, Table * elements, int xoff, int yoff) {
  
  long left = group->start().ticks();
  for (int i=0; i<elements->size(); i++) {
    ScoreElement * el = (ScoreElement*) elements->get(i);
    int deltax = int((el->start() - left) * unitsPerTick);  
    el->paint(ed, deltax + xoff, yoff);
  }
}



// *********************************************
// **                                         **
// **                                         **
// **                 CHORD                   **
// **                                         **
// **                                         **
// *********************************************


void TextScorePainter::paintChord(ScoreChord * chord, PrScoreEditor * ed, Table * notes, int xoff, int yoff) {

  // cout << "xoff: " << xoff << endl;

  Screen * screen = ((TextScoreEditor*)ed)->screen();
  yoff -= 8;

  initChordGeometry(1, 1);
  Note * note = 0;

  for (int i=0; i<notes->size(); i++) {
    note = ((Note*)((Reference*)notes->get(i))->getValue());
    if (note!=0) {
      use(note, chord);
      
      // draw helplines, above and below the score:
      for (int i=c_geometry->ypos/2; i<6; i++) { screen->draw(xoff-1, i*2+yoff+1, xoff+1, i*2+yoff+1); }
      for (int i=(c_geometry->ypos-1)/2; i>10; i--) { screen->draw(xoff-1, i*2+yoff+1, xoff+1, i*2+yoff+1); }
      
      // draw sign
      if (c_geometry->sgn != 0) { screen->put(xoff-1, c_geometry->ypos + yoff-(c_geometry->sgn<0), imgSigns[c_geometry->sgn+2]); }
      // chose and draw notebody (empty or filled):
      if (c_geometry->len>767) { noteImg = 'O'; } else { noteImg = '@'; }
      
      /*if (selectioN->hasEntry(note)) {
	score->fillRect(xx+xxShift-2,yy*3+yoffset-2,11,7,Qt::darkGray);
	} else {
	if (colorchan && (chan>-1)) {
	score->setPen(QColor((chan*33)%360,120,240,QColor::Hsv));
	} else {
	score->setPen(Qt::black);
	}
	}*/
      screen->put(xoff + (c_geometry->neighbour_offset?1:0), c_geometry->ypos + yoff, noteImg);
      
      for (int i=0;i<dot();i++) {
	screen->text(xoff + (c_geometry->neighbour_offset?1:0) +1+i, c_geometry->ypos + yoff, ".");
      }
    } else cout << "i(size): " << i << " (" << notes->size() << ") at:" << chord->start() << endl;
  }
  
  makeChordGeometry(xoff);

  //
  // draw stem and flags
  //
  int num = flags();
  if (c_geometry->stemDir==-1 && c_geometry->len<1535) {
    screen->draw(xoff + (c_geometry->neighbour_offset?1:0), c_geometry->yBottom-7, xoff+(c_geometry->neighbour_offset?1:0), c_geometry->yBottom-7+2);
    for (int i=0; i<num; i++) screen->put(xoff+(c_geometry->neighbour_offset?1:0)+1, c_geometry->yBottom-7+2-i, '/');
  } else {
    screen->draw(xoff+(c_geometry->neighbour_offset?1:0), c_geometry->yTop-9, xoff+(c_geometry->neighbour_offset?1:0), c_geometry->yTop-9-2);
    for (int i=0; i<num; i++) screen->put(xoff+(c_geometry->neighbour_offset?1:0)+1, c_geometry->yTop-9-2+i, '\\');
  }

  //
  // draw lyrics
  //
  screen->text(xoff, yoff+25, lyrics());
}



// *********************************************
// **                                         **
// **                                         **
// **                 BREAK                   **
// **                                         **
// **                                         **
// *********************************************


void TextScorePainter::paintBreak(ScoreBreak * brk, PrScoreEditor * ed, int xoff, int yoff) {
  
  Screen * screen = ((TextScoreEditor*)ed)->screen();

  int cl = int(pow(2, lengthOrd(brk->display()))); // 1 = whole, 2=half, 4=quater

  screen->text(xoff, yoff+8, string(cl));
}


/*
     *            
----*-*-----------
    * *           
----**------------
    **            
---*-*------------
  * ***           
--**-*-*----------
   ****           
-----*------------
   ***            
   **

4: 5
5: 4, 6
6: 4, 6
7: 4, 5
8: 4, 5
9: 3, 5
10:2, 4, 5, 6
11:2, 3, 5, 7
12:3, 4, 5, 6
13:5
14:3, 4, 5
15:3, 4

------------------
|  ****  *        
|-***--*----------
|  *   * *        
|------*----------
|     *           
|----*------------
|   *             
------------------
                  

6: 3, 4, 5, 6, 9
7: 2, 3, 4, 7
8: 3, 7, 9
9: 7
10: 6
11:5
12:4


*/


#endif
