#ifndef _TRACK_H_
#define _TRACK_H_

#include "compound.h"
#include "position.h"

#include "config.h"

#ifdef HAVE_ARTS_ENVIRONMENT
#include "arts/artsmodules.h"
#endif

class String;
class PrTrack;
class Event;
class Note;
class Reference;
class Part;
class Table;

typedef Element * (*EVENTLOAD)(char*,ifstream*&,Element*);

class Track : public Compound
{

 private:
  String * _name;
  bool _mute;
  bool _lock;

  void initEnvironment();
#ifdef HAVE_ARTS_ENVIRONMENT
  Arts::Environment::InstrumentItem _arts_instument;
#endif


 protected:
  PrTrack * _pr;

 public:

  Track();
  Track(const Track&,Type);
  ~Track();

  /** Returns the track name */
  String * name() const { return _name; }

  /** Returns true if the track is muted */
  bool mute() const { return _mute; }

  /** Returns true if the track is locked */
  bool lock() const { return _lock; }

  /** Returns the pitch of the note n (for Score- and DrumTracks) - including the track's transpose value */
  int pitch(Note * n) const;

  /** Returns the velocity of the note n - including the track's volume value */
  int vel(Note * n) const;

  /** Returns the track's delay */
  int delay() const;

  /** Returns the track's channel */
  int channel() const;

  /** Returns the track's program */
  int program() const;

  /** Sets the name */
  void setName(String*);

  /** Sets the name */
  void setName(const char*);

  /** Sets the mute value to m */
  void setMute(bool m);

  /** Sets the lock value to l */
  void setLock(bool l);

#ifdef HAVE_ARTS_ENVIRONMENT
  Arts::Environment::InstrumentItem envInstrument() const { return _arts_instument; }
#endif

  /** Returns the presentation (for internal use only) */
  PrTrack * presentation() const { return _pr; }

  /** Reimplement this for a new track type if you need a special ordering of the events */
  virtual void add(Element *);

  /** For internal use */
  virtual void hide();

  /** For internal use */
  virtual void show();

  /** Reimplement this for a new track type's options */
  virtual ostream & printOptions(int,ostream&) const = 0;

  /** For internal use */
  virtual ostream & print(int,ostream&) const;

  /** For internal use */
  virtual void flush(const char*) const;

  /** Reimplement this for a new track type */
  virtual Element * copy() const = 0;

  /** Reimplement this for a new track type's options */
  virtual void loadOpt(ifstream*&);

  /** For internal use */
  static Element * load(char*,ifstream*&,Element*);

  /** Returns true for all tracks */
  virtual bool isTrack() const;

  /** For internal use */
  virtual bool isMixable() const;

  /** Reimplement this for a new Addon's track type. This should always return the same as the
   * Addon's global c-function <ADDON>_name()
   **/
  virtual const char * eventType();

  /**
   * reimplement this for a new Addon's track type. This should return the address of the event's static load
   * function used, like "&MyEvent::load", which has to be implemented as
   *
   * static Element * load(char*,ifstream*&,Element*);
   *
   **/
  virtual EVENTLOAD eventLoad();
};

#endif
