/**
 * @file decode.h
 * C2N pulse stream decoder interface
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/* Copyright  2001 Marko Mkel.

   This file is part of C2N, a program for processing data tapes in
   Commodore C2N format.

   C2N is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   C2N is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** C2N pulse stream decoder
 * @param rd	the pulse stream reader
 * @param err	the error reporter
 * @param out	the data output stream
 * @return	number of bytes converted
 */
unsigned
decode (pulse_r_t rd, pulse_error_t err, FILE* out);

/** Commodore 1531 (Commodore 264 series) pulse stream decoder
 * @param rd	the pulse stream reader
 * @param err	the error reporter
 * @param out	the data output stream
 * @return	number of bytes converted
 */
unsigned
decode264 (pulse_r_t rd, pulse_error_t err, FILE* out);
