#include "main.h"
#include "time.h"
#include <stdlib.h>

float sine[100];

float mysin ( float ofs, float stretch)
{
    int param = ofs / stretch * 100;
    param = param % 100;

    //printf("%f\n",sin( (ofs/(0.2*M_PI)) / stretch )/2+0.5);
    return sine[param];
}

#define SINE_COUNT 4

void GenerateSine()
{
    int i;
    
    for (i=0;i<100;i++) {
	sine[i] = (sin(((float)i/99)*2*M_PI)/4+0.5)*255; // I know that this is weird
    }
}

void DrawGround()
{
    Uint32 x,y;
    Uint8 r,g,b,i;
    int x2,y2,range=2;
    float stretch[SINE_COUNT],xfactor[SINE_COUNT],yfactor[SINE_COUNT],value;
    SDL_Rect destrect, srcrect;
    
    srcrect.w = srcrect.h = destrect.w = destrect.h = 1;
    srcrect.y = 0;

    for (y=0;y<Height;y++) {
        for (x=0;x<Width;x++) {
	    Garbage[x][y] = 0;
	    House[x][y] = 0;
	}
    }

    for (i=0;i<SINE_COUNT;i++) {
	stretch[i] = abrand(1000,2400);
	xfactor[i] = abrand(0,250/M_PI)/10;
	yfactor[i] = abrand(0,250/M_PI)/10;
    }

//    lock(BackBuffer);
    for (y=0;y<Height*BSIZE;y++) {
        for (x=0;x<Width*BSIZE;x++) {

//	    g=mysin(x,20)/3+mysin(y,50)/3+mysin(y+2*x,150)/3;
	    value=0;
	    for (i=0;i<SINE_COUNT;i++)
		value += mysin(x*xfactor[i]+y*yfactor[i],stretch[i])/SINE_COUNT;
	    
	    value += abrand(-4,4);
	    
	    if (!Conquer)
	    for (y2=-range;y2<=range;y2++) {
    		for (x2=-range;x2<=range;x2++) {
		    int dx,dy;
		
		    dx=x+x2;
		    dy=y+y2;
		
		    if (dx<0)
			dx=0;

		    if (dy<0)
			dy=0;
		
		    if (dx>=Width*BSIZE)
			dx=Width*BSIZE-1;

		    if (dy>=Height*BSIZE)
			dy=Height*BSIZE-1;
		
		    if (Landscape[(int)(dx/BSIZE)][(int)(dy/BSIZE)]==127)
			value -= (float)255/((range*2+1)*(range*2+1));
		}
	    }
	    
	    r = 0; g = 0; b = 0;

/*	    if (Landscape[(int)(x/BSIZE)][(int)(y/BSIZE)]==127)
		value -= 256;*/
	    
/*	    if (value > 0)
		g = value;
	    else
		b = 256+value;*/
	    
/*	    if (Landscape[(int)(x/BSIZE)][(int)(y/BSIZE)]==127) {
		r = 0;
		g = 0;
		b = value;
	    } else {
		r = 0;
		g = value;
		b = 0;
	    }
*/
	    destrect.x = x;
	    destrect.y = y;
	    srcrect.x  = 256-(int)value;
	    SDL_BlitSurface( GradientPic, &srcrect, BackBuffer, &destrect);
	    
//	    pixel = SDL_MapRGBA( BackBuffer->format, r, g, b, 255);
//	    PutPixel( BackBuffer, x, y, pixel);
	}
    }
//    unlock(BackBuffer);
}

int CastleNear(int x1, int y1)
{
    int x2,y2,x,y,cas,dist=7;
    
    for (x2= -dist; x2<=dist; x2++) {
	for (y2= -dist; y2<=dist; y2++) {
	    x = x1-x2;
	    y =	y1-y2;
	    
	    if ( (x>=0) && (x<Width) && (y>=0) && (y<Height) ) {
		for (cas=0; cas<CastleNum; cas++) {
		    if ( (Castle[cas].x == x) && (Castle[cas].y ==y) )
			return 1;
		}
	    }
	}
    }
    
    return 0;
}

void RandomizeCastles(char seed)
{
    int i,x,y;
    char data[3];

    srand(seed);
    for (i=0; i<CastleNum; i++) {
	do {
	    x = abrand(4,Width-6);
	    y = abrand(4,Height-6);
	} while (CastleNear(x,y));
	
	Castle[i].x = x;
	Castle[i].y = y;
    }
    
    if (Master) {
	data[0] = 2;
	data[1] = NET_CASTLE_RANDOMIZE;
	data[2] = seed;
	Net_Send(data);
    }
}

void GenerateLand() {
    int x,y,i;
    
    // Clear map
    for (y=0;y<HEIGHT;y++) {
	for (x=0;x<WIDTH;x++) {
	    Wall[x][y]=0;
	    Garbage[x][y]=0;
	    House[x][y]=0;
	    Landscape[x][y]=0;
    	    for (i=0; i<PlayerNum; i++)
    		BPlayer[i].Secured[x][y]=0;
        }
    }

    if (PlayerNum == 1) {
    
	Width=40;
	Height=30;
	
	// Resize window
	if ( (Width*BSIZE!=800) || (Height*BSIZE!=600) )
    	    Resize( Width*BSIZE, Height*BSIZE );
    
        for (y=0;y<Height;y++) {
	    for (x=0;x<Width/2-1;x++)
		Landscape[x][y]=0;
	    if (!Conquer) {
		for (x=Width/2-1;x<Width/2+1;x++)
		    Landscape[x][y]=127;
	    }
	    for (x=Width/2+1;x<Width;x++)
		Landscape[x][y]=1;
	}

	DrawGround();

        Castle[0].x=Width/4-3;
        Castle[0].y=Height/4-2;
        Castle[0].Owner=0;
        Castle[1].x=Width/4-3;
        Castle[1].y=3*Height/4-2;
        Castle[1].Owner=0;

        CastleNum = 2;
	
    } else

    if ( (PlayerNum==2) && (!Conquer) ){

	Width=40;
	Height=30;
	
	// Resize window
	if ( (Width*BSIZE!=800) || (Height*BSIZE!=600) )
    	    Resize( Width*BSIZE, Height*BSIZE );


        for (y=0;y<Height;y++) {
	    for (x=0;x<Width/2-1;x++)
		Landscape[x][y]=0;
	    if (!Conquer) {
		for (x=Width/2-1;x<Width/2+1;x++)
		    Landscape[x][y]=127;
	    }
	    for (x=Width/2+1;x<Width;x++)
		Landscape[x][y]=1;
	}

	// Draw Map
	DrawGround();

        // castles
        Castle[0].x=Width/4-3;
        Castle[0].y=Height/4-2;
        Castle[0].Owner=0;
        Castle[1].x=Width/4-3;
        Castle[1].y=3*Height/4-2;
        Castle[1].Owner=0;
        Castle[2].x=3*Width/4-3;
        Castle[2].y=Height/4-2;
        Castle[2].Owner=1;
        Castle[3].x=3*Width/4-3;
        Castle[3].y=3*Height/4-2;
        Castle[3].Owner=1;
        Castle[4].x=Width/4-4;
        Castle[4].y=2*Height/4-3;
        Castle[4].Owner=0;
        Castle[5].x=3*Width/4-4;
        Castle[5].y=2*Height/4-3;
        Castle[5].Owner=1;
    
        CastleNum=6;
    
    } else
    
    if ( ((PlayerNum>2) && (PlayerNum<=4)) || (Conquer) ) {
    
	Width=50;
	Height=38;
	Resize( Width*BSIZE, Height*BSIZE );
    
	// Player's regions
        for (y=0;y<Height/2-1;y++)
	    for (x=0;x<Width/2-1;x++)
		Landscape[x][y]=0;
        for (y=0;y<Height/2-1;y++)
	    for (x=Width/2+1;x<Width;x++)
		Landscape[x][y]=1;
        for (y=Height/2+1;y<Height;y++) 
	    for (x=0;x<Width/2-1;x++)
		Landscape[x][y]=2;
        for (y=Height/2+1;y<Height;y++)
	    for (x=Width/2+1;x<Width;x++)
		Landscape[x][y]=3;

	// Rivers
	if (!Conquer) {
    	    for (y=0;y<Height;y++) 
		for (x=Width/2-1;x<Width/2+1;x++)
		    Landscape[x][y]=127;
    	    for (y=Height/2-1;y<Height/2+1;y++)
		for (x=0;x<Width;x++)
		    Landscape[x][y]=127;
	}
	
	// Draw Map
	DrawGround();

	// top
        Castle[0].x=Width/8-1;
        Castle[0].y=Height/4-1;
        Castle[0].Owner=0;
        Castle[1].x=Width/8*3-1;
        Castle[1].y=Height/4-1;
        Castle[1].Owner=0;
        Castle[2].x=Width/8*5+1;
        Castle[2].y=Height/4-1;
        Castle[2].Owner=1;
        Castle[3].x=Width/8*7+1;
        Castle[3].y=Height/4-1;
        Castle[3].Owner=1;
	// bottom
        Castle[4].x=Width/8-1;
        Castle[4].y=Height/4*3+1;
        Castle[4].Owner=2;
        Castle[5].x=Width/8*3-1;
        Castle[5].y=Height/4*3+1;
        Castle[5].Owner=2;
        Castle[6].x=Width/8*5+1;
        Castle[6].y=Height/4*3+1;
        Castle[6].Owner=3;
        Castle[7].x=Width/8*7+1;
        Castle[7].y=Height/4*3+1;
        Castle[7].Owner=3;
    
        // big castles
/*        Castle[4].x=Width/4-4;
        Castle[4].y=2*Height/4-3;
        Castle[4].Type=2;
        Castle[5].x=3*Width/4-4;
        Castle[5].y=2*Height/4-3;
        Castle[5].Type=2;*/
    
        CastleNum=8;
    
    } else {
	puts("Couldn't find a suitable level for this numer of Players!\n");
	exit(1);
    }
}

void FinishLand()
{
    int i;

    if ((Conquer)&&(Master)) {
	RandomizeCastles((char)time(NULL));
    }

    for (i=0;i<CastleNum;i++) {
        BlitToBB(Castle[i].x*BSIZE, Castle[i].y*BSIZE, CastlePic);
        Castle[i].Type=1;
    }    
    
    SDL_BlitSurface( BackBuffer, NULL, BackPic, NULL);
    Update();
    
}